/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.xml.ws.Holder;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.qubership.atp.mia.exceptions.fileservice.ArchiveIoExceptionDuringSave;
import org.qubership.atp.mia.exceptions.fileservice.CreateDirFailedException;
import org.qubership.atp.mia.exceptions.fileservice.ReadFailIoExceptionDuringOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static void logIntoFile(String logString, File file) {
        try {
            file.createNewFile();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));){
                writer.append(logString);
                writer.flush();
            }
            catch (IOException e) {
                log.error("Can't write response to file - IOException", (Throwable)e);
            }
        }
        catch (IOException e) {
            log.error("Can't create file - IOException", (Throwable)e);
        }
    }

    public static void addDirToZipArchive(ZipOutputStream zos, File fileToZip, String parentDirectoryName, IOFileFilter filter) {
        block14: {
            String zipEntryName;
            block13: {
                if (fileToZip == null || !fileToZip.exists()) {
                    return;
                }
                if (filter != null && !filter.accept(fileToZip)) {
                    log.trace("skipping file during archive: {}", (Object)fileToZip.getName());
                    return;
                }
                zipEntryName = fileToZip.getName();
                if (parentDirectoryName != null && !parentDirectoryName.isEmpty()) {
                    zipEntryName = parentDirectoryName + "/" + zipEntryName;
                }
                if (!fileToZip.isDirectory()) break block13;
                log.trace("|" + zipEntryName);
                File[] files = fileToZip.listFiles();
                if (files == null) break block14;
                for (File file : files) {
                    FileUtils.addDirToZipArchive(zos, file, zipEntryName, filter);
                }
                break block14;
            }
            log.trace(" +" + zipEntryName);
            byte[] buffer = new byte[1024];
            try (FileInputStream fis = new FileInputStream(fileToZip);){
                int length;
                zos.putNextEntry(new ZipEntry(zipEntryName));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
            }
            catch (FileNotFoundException e) {
                log.error("A file in archiving folder does not exist: %s", (Throwable)e);
            }
            catch (IOException e) {
                throw new ArchiveIoExceptionDuringSave(fileToZip.toString(), e);
            }
        }
    }

    public static File unzipConfig(File zipPath, File destDir) throws IOException {
        File file;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipPath));
        try {
            if (!destDir.exists()) {
                FileUtils.createDirectories(destDir.toPath());
            }
            byte[] buffer = new byte[1024];
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = FileUtils.newFile(destDir, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            file = destDir;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new IOException("Archive file not found! file: " + zipPath.getPath());
            }
        }
        zis.close();
        return file;
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public static void copyFilesFromCurrentDir(File src, File dest) throws IOException {
        org.apache.commons.io.FileUtils.copyDirectory((File)src, (File)dest);
        org.apache.commons.io.FileUtils.copyDirectory((File)src, (File)dest);
    }

    public static void deleteFolder(File dir, boolean deleteNowDir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtils.deleteFolder(f, true);
                    continue;
                }
                f.delete();
            }
        }
        if (deleteNowDir) {
            dir.delete();
        }
    }

    public static void deleteFolders(boolean deleteNowDir, File[] dirs) {
        if (dirs != null) {
            for (File dir : dirs) {
                if (!dir.exists() || !dir.isDirectory()) continue;
                FileUtils.deleteFolder(dir, deleteNowDir);
            }
        }
    }

    public static File findFileAndGetParent(File inputDir, String searchDirName) throws FileNotFoundException {
        File[] files;
        File foundFile = null;
        ArrayList<File> directories = new ArrayList<File>();
        if (inputDir.isDirectory() && (files = inputDir.listFiles()) != null) {
            for (File f : files) {
                if (f.getName().equals(searchDirName)) {
                    foundFile = f;
                    break;
                }
                if (!f.isDirectory()) continue;
                directories.add(f);
            }
            if (foundFile == null && !directories.isEmpty()) {
                File f;
                Iterator iterator = directories.iterator();
                while (iterator.hasNext() && (foundFile = FileUtils.findFileAndGetParent(f = (File)iterator.next(), searchDirName)) == null) {
                }
            }
        }
        if (foundFile == null) {
            throw new FileNotFoundException("File not found:" + searchDirName);
        }
        return foundFile;
    }

    public static String readFile(Path pathToFile) {
        try {
            return new String(Files.readAllBytes(pathToFile.toRealPath(new LinkOption[0]).normalize()));
        }
        catch (IOException e) {
            throw new ReadFailIoExceptionDuringOperation(pathToFile.toString(), e);
        }
    }

    public static void copyFolder(Path src, Path dest) throws IOException {
        Holder exception = new Holder(null);
        Files.walk(src, new FileVisitOption[0]).forEach(s -> {
            try {
                Path d = dest.resolve(src.relativize((Path)s));
                if (Files.isDirectory(s, new LinkOption[0])) {
                    if (!Files.exists(d, new LinkOption[0])) {
                        Files.createDirectory(d, new FileAttribute[0]);
                    }
                    return;
                }
                Files.copy(s, d, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                exception.value = e;
            }
        });
        if (exception.value != null) {
            throw (IOException)exception.value;
        }
    }

    public static void copyFile(Path src, Path dest) throws IOException {
        Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void removeFile(String fileToDelete) {
        try {
            Files.deleteIfExists(Paths.get(fileToDelete, new String[0]));
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public static void createDirectories(Path pathToCreate) {
        try {
            Files.createDirectories(pathToCreate, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CreateDirFailedException(pathToCreate, e);
        }
    }

    @Nonnull
    public static String tempFileName(String dir, String fileName) {
        String path = "/";
        if (dir != null) {
            String startSlash = dir.startsWith("/") || dir.isEmpty() ? "" : "/";
            String endSlash = dir.endsWith("/") ? "" : "/";
            path = startSlash + dir + endSlash;
        }
        return path + fileName;
    }

    public static Path getPathToFileFromFile(File file) {
        Path path = Paths.get(file.getName(), new String[0]);
        Path parent = Paths.get(file.getParent(), new String[0]);
        while (!parent.getFileName().toString().equals("flow")) {
            path = Paths.get(parent.getFileName().toString(), new String[0]).resolve(path);
            parent = parent.getParent();
        }
        return path.normalize();
    }

    public static void createFolder(File targetFile) {
        if (!targetFile.exists()) {
            try {
                Files.createDirectories(targetFile.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new CreateDirFailedException(targetFile.toPath().getParent(), e);
            }
        }
    }
}

