/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils.dos2unix;

import java.util.Optional;
import org.qubership.atp.mia.utils.dos2unix.Dos2Unix;
import org.qubership.atp.mia.utils.dos2unix.impl.LinuxDos2Unix;
import org.qubership.atp.mia.utils.dos2unix.impl.WindowsDos2Unix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dos2UnixFactory {
    private static final Logger log = LoggerFactory.getLogger(Dos2UnixFactory.class);

    public static Optional<Dos2Unix> getDos2Unix(String osName, String dos2UnixPath) {
        Optional<Dos2Unix> res = Optional.empty();
        String name = osName.toLowerCase();
        if (name.startsWith("linux")) {
            log.debug("Returning linux dos2unix");
            res = Optional.of(new LinuxDos2Unix(dos2UnixPath));
        } else if (name.startsWith("windows")) {
            log.debug("Returning windows dos2unix");
            res = Optional.of(new WindowsDos2Unix(dos2UnixPath));
        } else {
            log.debug("Returning empty instead of dos2unix");
        }
        return res;
    }
}

