/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils.dos2unix.impl;

import java.nio.file.Path;
import java.util.concurrent.Executors;
import org.qubership.atp.mia.exceptions.dos2unix.Dos2unixWindowsFailException;
import org.qubership.atp.mia.utils.dos2unix.Dos2Unix;
import org.qubership.atp.mia.utils.dos2unix.utils.Dos2UnixUtils;
import org.qubership.atp.mia.utils.dos2unix.utils.StreamGobbler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsDos2Unix
implements Dos2Unix {
    private static final Logger log = LoggerFactory.getLogger(WindowsDos2Unix.class);
    private final String pathToDos2Unix;

    public WindowsDos2Unix(String pathToDos2Unix) {
        this.pathToDos2Unix = pathToDos2Unix;
    }

    @Override
    public void runDos2Unix(Path destSource) {
        log.info("Run dos2unix for windows");
        String dosPath = Dos2UnixUtils.getDos2UnixPath(this.pathToDos2Unix, new String[0]).toString();
        String dest = Dos2UnixUtils.destinationToRealPath(destSource).toString();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("cmd.exe", "/c", dosPath, dest);
        log.info("Command builder ready, running...");
        int exitVal = 0;
        try {
            Process process = builder.start();
            Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getInputStream(), arg_0 -> ((Logger)log).trace(arg_0)));
            Executors.newSingleThreadExecutor().submit(new StreamGobbler(process.getErrorStream(), arg_0 -> ((Logger)log).trace(arg_0)));
            exitVal = process.waitFor();
        }
        catch (Exception e) {
            throw new Dos2unixWindowsFailException(e);
        }
        if (exitVal == 0) {
            log.info("File conversion to Unix Format is Success! Path: {}", (Object)dest);
        } else {
            log.error("File conversion to Unix Format is Fail! & Command Exit Value is : {}. Path: {}", (Object)exitVal, (Object)dest);
        }
    }
}

