/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils.dos2unix.utils;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.qubership.atp.mia.exceptions.dos2unix.Dos2unixIncorrectFilePathException;
import org.qubership.atp.mia.exceptions.dos2unix.Dos2unixIncorrectToolPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dos2UnixUtils {
    private static final Logger log = LoggerFactory.getLogger(Dos2UnixUtils.class);

    public static Path getDos2UnixPath(String pathToDos2UnixS, String ... pathToDos2Unix) {
        try {
            return Paths.get(pathToDos2UnixS, pathToDos2Unix).toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new Dos2unixIncorrectToolPathException(Paths.get(pathToDos2UnixS, pathToDos2Unix).toAbsolutePath(), e);
        }
    }

    public static Path destinationToRealPath(Path dest) {
        try {
            dest = dest.toRealPath(new LinkOption[0]);
            log.info("Real path to file which will be converted by dos2unix: {}", (Object)dest.toString());
            return dest;
        }
        catch (IOException e) {
            throw new Dos2unixIncorrectFilePathException(dest.toString(), e);
        }
    }
}

