package org.qubership.atp.mia.clients.api.environments.dto.projects;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProjectSearchRequestDto
 */

@JsonTypeName("ProjectSearchRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:26.084481072Z[Etc/UTC]")
public class ProjectSearchRequestDto implements Serializable {

  private static final long serialVersionUID = 1L;

  @Valid
  private List<UUID> projectIds;

  @Valid
  private List<String> projectNames;

  @Valid
  private List<UUID> environmentIds;

  @Valid
  private List<String> environmentNames;

  @Valid
  private List<UUID> systemIds;

  @Valid
  private List<String> systemNames;

  public ProjectSearchRequestDto projectIds(List<UUID> projectIds) {
    this.projectIds = projectIds;
    return this;
  }

  public ProjectSearchRequestDto addProjectIdsItem(UUID projectIdsItem) {
    if (this.projectIds == null) {
      this.projectIds = new ArrayList<>();
    }
    this.projectIds.add(projectIdsItem);
    return this;
  }

  /**
   * Get projectIds
   * @return projectIds
  */
  @Valid 
  @Schema(name = "projectIds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("projectIds")
  public List<UUID> getProjectIds() {
    return projectIds;
  }

  public void setProjectIds(List<UUID> projectIds) {
    this.projectIds = projectIds;
  }

  public ProjectSearchRequestDto projectNames(List<String> projectNames) {
    this.projectNames = projectNames;
    return this;
  }

  public ProjectSearchRequestDto addProjectNamesItem(String projectNamesItem) {
    if (this.projectNames == null) {
      this.projectNames = new ArrayList<>();
    }
    this.projectNames.add(projectNamesItem);
    return this;
  }

  /**
   * Get projectNames
   * @return projectNames
  */
  
  @Schema(name = "projectNames", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("projectNames")
  public List<String> getProjectNames() {
    return projectNames;
  }

  public void setProjectNames(List<String> projectNames) {
    this.projectNames = projectNames;
  }

  public ProjectSearchRequestDto environmentIds(List<UUID> environmentIds) {
    this.environmentIds = environmentIds;
    return this;
  }

  public ProjectSearchRequestDto addEnvironmentIdsItem(UUID environmentIdsItem) {
    if (this.environmentIds == null) {
      this.environmentIds = new ArrayList<>();
    }
    this.environmentIds.add(environmentIdsItem);
    return this;
  }

  /**
   * Get environmentIds
   * @return environmentIds
  */
  @Valid 
  @Schema(name = "environmentIds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("environmentIds")
  public List<UUID> getEnvironmentIds() {
    return environmentIds;
  }

  public void setEnvironmentIds(List<UUID> environmentIds) {
    this.environmentIds = environmentIds;
  }

  public ProjectSearchRequestDto environmentNames(List<String> environmentNames) {
    this.environmentNames = environmentNames;
    return this;
  }

  public ProjectSearchRequestDto addEnvironmentNamesItem(String environmentNamesItem) {
    if (this.environmentNames == null) {
      this.environmentNames = new ArrayList<>();
    }
    this.environmentNames.add(environmentNamesItem);
    return this;
  }

  /**
   * Get environmentNames
   * @return environmentNames
  */
  
  @Schema(name = "environmentNames", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("environmentNames")
  public List<String> getEnvironmentNames() {
    return environmentNames;
  }

  public void setEnvironmentNames(List<String> environmentNames) {
    this.environmentNames = environmentNames;
  }

  public ProjectSearchRequestDto systemIds(List<UUID> systemIds) {
    this.systemIds = systemIds;
    return this;
  }

  public ProjectSearchRequestDto addSystemIdsItem(UUID systemIdsItem) {
    if (this.systemIds == null) {
      this.systemIds = new ArrayList<>();
    }
    this.systemIds.add(systemIdsItem);
    return this;
  }

  /**
   * Get systemIds
   * @return systemIds
  */
  @Valid 
  @Schema(name = "systemIds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("systemIds")
  public List<UUID> getSystemIds() {
    return systemIds;
  }

  public void setSystemIds(List<UUID> systemIds) {
    this.systemIds = systemIds;
  }

  public ProjectSearchRequestDto systemNames(List<String> systemNames) {
    this.systemNames = systemNames;
    return this;
  }

  public ProjectSearchRequestDto addSystemNamesItem(String systemNamesItem) {
    if (this.systemNames == null) {
      this.systemNames = new ArrayList<>();
    }
    this.systemNames.add(systemNamesItem);
    return this;
  }

  /**
   * Get systemNames
   * @return systemNames
  */
  
  @Schema(name = "systemNames", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("systemNames")
  public List<String> getSystemNames() {
    return systemNames;
  }

  public void setSystemNames(List<String> systemNames) {
    this.systemNames = systemNames;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectSearchRequestDto projectSearchRequest = (ProjectSearchRequestDto) o;
    return Objects.equals(this.projectIds, projectSearchRequest.projectIds) &&
        Objects.equals(this.projectNames, projectSearchRequest.projectNames) &&
        Objects.equals(this.environmentIds, projectSearchRequest.environmentIds) &&
        Objects.equals(this.environmentNames, projectSearchRequest.environmentNames) &&
        Objects.equals(this.systemIds, projectSearchRequest.systemIds) &&
        Objects.equals(this.systemNames, projectSearchRequest.systemNames);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectIds, projectNames, environmentIds, environmentNames, systemIds, systemNames);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectSearchRequestDto {\n");
    sb.append("    projectIds: ").append(toIndentedString(projectIds)).append("\n");
    sb.append("    projectNames: ").append(toIndentedString(projectNames)).append("\n");
    sb.append("    environmentIds: ").append(toIndentedString(environmentIds)).append("\n");
    sb.append("    environmentNames: ").append(toIndentedString(environmentNames)).append("\n");
    sb.append("    systemIds: ").append(toIndentedString(systemIds)).append("\n");
    sb.append("    systemNames: ").append(toIndentedString(systemNames)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

