/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.6.0).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.mia.controllers.api;

import org.qubership.atp.mia.controllers.api.dto.CompoundDto;
import org.qubership.atp.mia.controllers.api.dto.CompoundShortDto;
import org.qubership.atp.mia.controllers.api.dto.FlowConfigDto;
import org.qubership.atp.mia.controllers.api.dto.MoveDirectoryRequestDto;
import org.qubership.atp.mia.controllers.api.dto.MoveProjectFileRequestDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessShortDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectConfigurationDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectDirectoriesDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectDirectoryDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectFileDto;
import org.qubership.atp.mia.controllers.api.dto.SectionDto;
import org.qubership.atp.mia.controllers.api.dto.SectionsDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:28.608433070Z[Etc/UTC]")
@Validated
@Tag(name = "mia-configuration-controller", description = "MIA Configuration Controller")
public interface MiaConfigurationControllerApi {

    /**
     * POST /configuration/{projectId}/compound
     * Add mia compound
     *
     * @param projectId Project ID (required)
     * @param compoundDto request (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "addCompound",
        description = "Add mia compound",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompoundDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/configuration/{projectId}/compound",
        produces = { "application/json" },
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<CompoundDto> addCompound(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "CompoundDto", description = "request", required = true) @Valid @RequestBody CompoundDto compoundDto
    );


    /**
     * POST /configuration/{projectId}/directory
     * Add mia directory
     *
     * @param projectId Project ID (required)
     * @param projectDirectoryDto request (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "addDirectory",
        description = "Add mia directory",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/configuration/{projectId}/directory",
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<Void> addDirectory(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "ProjectDirectoryDto", description = "request", required = true) @Valid @RequestBody ProjectDirectoryDto projectDirectoryDto
    );


    /**
     * POST /configuration/{projectId}/process
     * Add mia process
     *
     * @param projectId Project ID (required)
     * @param processDto request (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "addProcess",
        description = "Add mia process",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProcessDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/configuration/{projectId}/process",
        produces = { "application/json" },
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<ProcessDto> addProcess(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "ProcessDto", description = "request", required = true) @Valid @RequestBody ProcessDto processDto
    );


    /**
     * POST /configuration/{projectId}/projectFile
     * Add mia project file
     *
     * @param projectId Project ID (required)
     * @param projectFile  (required)
     * @param file  (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "addProjectFile",
        description = "Add mia project file",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/configuration/{projectId}/projectFile",
        consumes = { "multipart/form-data" }
    )
    ResponseEntity<Void> addProjectFile(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "projectFile", description = "", required = true) @Valid @RequestPart(value = "projectFile", required = true) ProjectFileDto projectFile,
        @Parameter(name = "file", description = "", required = true) @RequestPart(value = "file", required = true) MultipartFile file
    );


    /**
     * POST /configuration/{projectId}/section
     * Add mia section
     *
     * @param projectId Project ID (required)
     * @param sectionDto request (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "addSection",
        description = "Add mia section",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = SectionsDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/configuration/{projectId}/section",
        produces = { "application/json" },
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<List<SectionsDto>> addSection(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "SectionDto", description = "request", required = true) @Valid @RequestBody SectionDto sectionDto
    );


    /**
     * DELETE /configuration/{projectId}/compound/{compoundId}
     * Delete mia compound
     *
     * @param projectId Project ID (required)
     * @param compoundId Compound ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "deleteCompound",
        description = "Delete mia compound",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = CompoundShortDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/configuration/{projectId}/compound/{compoundId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<CompoundShortDto>> deleteCompound(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "compoundId", description = "Compound ID", required = true, in = ParameterIn.PATH) @PathVariable("compoundId") UUID compoundId
    );


    /**
     * DELETE /configuration/{projectId}
     * Delete mia configuration
     *
     * @param projectId Project ID (required)
     * @param withPOT Remove with POT (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "deleteConfiguration",
        description = "Delete mia configuration",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/configuration/{projectId}"
    )
    ResponseEntity<Void> deleteConfiguration(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @NotNull @Parameter(name = "withPOT", description = "Remove with POT", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "withPOT", required = true) Boolean withPOT
    );


    /**
     * DELETE /configuration/{projectId}/directory/{directoryId}
     * Delete mia directory
     *
     * @param projectId Project ID (required)
     * @param directoryId Directory ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "deleteDirectory",
        description = "Delete mia directory",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/configuration/{projectId}/directory/{directoryId}"
    )
    ResponseEntity<Void> deleteDirectory(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "directoryId", description = "Directory ID", required = true, in = ParameterIn.PATH) @PathVariable("directoryId") UUID directoryId
    );


    /**
     * DELETE /configuration/{projectId}/process/{processId}
     * Delete mia process
     *
     * @param projectId Project ID (required)
     * @param processId Process ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "deleteProcess",
        description = "Delete mia process",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = ProcessShortDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/configuration/{projectId}/process/{processId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProcessShortDto>> deleteProcess(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "processId", description = "Process ID", required = true, in = ParameterIn.PATH) @PathVariable("processId") UUID processId
    );


    /**
     * DELETE /configuration/{projectId}/projectFile/{fileId}
     * Delete mia section
     *
     * @param projectId Project ID (required)
     * @param fileId Project file ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "deleteProjectFile",
        description = "Delete mia section",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/configuration/{projectId}/projectFile/{fileId}"
    )
    ResponseEntity<Void> deleteProjectFile(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "fileId", description = "Project file ID", required = true, in = ParameterIn.PATH) @PathVariable("fileId") UUID fileId
    );


    /**
     * DELETE /configuration/{projectId}/section/{sectionId}
     * Delete mia section
     *
     * @param projectId Project ID (required)
     * @param sectionId Section ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "deleteSection",
        description = "Delete mia section",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = SectionsDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/configuration/{projectId}/section/{sectionId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<SectionsDto>> deleteSection(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "sectionId", description = "Section ID", required = true, in = ParameterIn.PATH) @PathVariable("sectionId") UUID sectionId
    );


    /**
     * GET /configuration/{projectId}/downloadZipConfig
     * Download config as ZIP file
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "downloadZipConfig",
        description = "Download config as ZIP file",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/octet-stream", schema = @Schema(implementation = org.springframework.core.io.Resource.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/downloadZipConfig",
        produces = { "application/octet-stream" }
    )
    ResponseEntity<org.springframework.core.io.Resource> downloadZipConfig(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /configuration/{projectId}/compound/{compoundId}
     * Get mia compound
     *
     * @param projectId Project ID (required)
     * @param compoundId Compound ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getCompound",
        description = "Get mia compound",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompoundDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/compound/{compoundId}",
        produces = { "application/json" }
    )
    ResponseEntity<CompoundDto> getCompound(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "compoundId", description = "Compound ID", required = true, in = ParameterIn.PATH) @PathVariable("compoundId") UUID compoundId
    );


    /**
     * GET /configuration/{projectId}/compound
     * Get mia all compounds for the project
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getCompounds",
        description = "Get mia all compounds for the project",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = CompoundShortDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/compound",
        produces = { "application/json" }
    )
    ResponseEntity<List<CompoundShortDto>> getCompounds(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /rest/config
     * IMPORTANT. IT IS OLD CONFIG!!! USE /configuration/{projectId}, /configuration/{projectId}/section,  /configuration/{projectId}/compound, /configuration/{projectId}/process instead. 
     *
     * @param projectId Project ID (required)
     * @param needReload needReload (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     * @deprecated
     */
    @Deprecated
    @Operation(
        operationId = "getConfig",
        description = "IMPORTANT. IT IS OLD CONFIG!!! USE /configuration/{projectId}, /configuration/{projectId}/section,  /configuration/{projectId}/compound, /configuration/{projectId}/process instead. ",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = FlowConfigDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/rest/config",
        produces = { "application/json" }
    )
    ResponseEntity<FlowConfigDto> getConfig(
        @NotNull @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @NotNull @Parameter(name = "needReload", description = "needReload", required = true, in = ParameterIn.QUERY) @Valid @RequestParam(value = "needReload", required = true) Boolean needReload
    );


    /**
     * GET /configuration/{projectId}
     * Get mia configuration
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConfiguration",
        description = "Get mia configuration",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectConfigurationDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectConfigurationDto> getConfiguration(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /configuration/{projectId}/hardReload
     * Hard reload mia configuration from external resourse and return it
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConfigurationWithHardReload",
        description = "Hard reload mia configuration from external resourse and return it",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectConfigurationDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/hardReload",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectConfigurationDto> getConfigurationWithHardReload(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /configuration/{projectId}/directory
     * Get mia directories hierarchy
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDirectories",
        description = "Get mia directories hierarchy",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDirectoriesDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/directory",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectDirectoriesDto> getDirectories(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /configuration/{projectId}/process/{processId}
     * Get mia process
     *
     * @param projectId Project ID (required)
     * @param processId Process ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProcess",
        description = "Get mia process",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProcessDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/process/{processId}",
        produces = { "application/json" }
    )
    ResponseEntity<ProcessDto> getProcess(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "processId", description = "Process ID", required = true, in = ParameterIn.PATH) @PathVariable("processId") UUID processId
    );


    /**
     * GET /configuration/{projectId}/process
     * Get mia all processes for the project
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProcesses",
        description = "Get mia all processes for the project",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = ProcessShortDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/process",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProcessShortDto>> getProcesses(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /configuration/{projectId}/projectFile/{fileId}
     * Get mia project file
     *
     * @param projectId Project ID (required)
     * @param fileId Project file ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectFile",
        description = "Get mia project file",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/octet-stream", schema = @Schema(implementation = org.springframework.core.io.Resource.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/projectFile/{fileId}",
        produces = { "application/octet-stream" }
    )
    ResponseEntity<org.springframework.core.io.Resource> getProjectFile(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "fileId", description = "Project file ID", required = true, in = ParameterIn.PATH) @PathVariable("fileId") UUID fileId
    );


    /**
     * GET /configuration/{projectId}/section
     * Get mia sections hierarchy
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSections",
        description = "Get mia sections hierarchy",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = SectionsDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/section",
        produces = { "application/json" }
    )
    ResponseEntity<List<SectionsDto>> getSections(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /configuration/{projectId}/directories
     * Get mia list of uuids for all directories
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getUuidDirectories",
        description = "Get mia list of uuids for all directories",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = UUID.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/directories",
        produces = { "application/json" }
    )
    ResponseEntity<List<UUID>> getUuidDirectories(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /configuration/{projectId}/projectFiles
     * Get mia list of uuids for all files
     *
     * @param projectId Project ID (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getUuidFiles",
        description = "Get mia list of uuids for all files",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = UUID.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/configuration/{projectId}/projectFiles",
        produces = { "application/json" }
    )
    ResponseEntity<List<UUID>> getUuidFiles(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId
    );


    /**
     * PATCH /configuration/{projectId}/directory/{directoryId}
     * Move mia project directory
     *
     * @param projectId Project ID (required)
     * @param directoryId Directory ID (required)
     * @param moveDirectoryRequestDto  (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "moveDirectory",
        description = "Move mia project directory",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/configuration/{projectId}/directory/{directoryId}",
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<Void> moveDirectory(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "directoryId", description = "Directory ID", required = true, in = ParameterIn.PATH) @PathVariable("directoryId") UUID directoryId,
        @Parameter(name = "MoveDirectoryRequestDto", description = "", required = true) @Valid @RequestBody MoveDirectoryRequestDto moveDirectoryRequestDto
    );


    /**
     * PATCH /configuration/{projectId}/projectFile/{fileId}
     * Move mia project file
     *
     * @param projectId Project ID (required)
     * @param fileId Project file ID (required)
     * @param moveProjectFileRequestDto  (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "moveProjectFile",
        description = "Move mia project file",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/configuration/{projectId}/projectFile/{fileId}",
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<Void> moveProjectFile(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "fileId", description = "Project file ID", required = true, in = ParameterIn.PATH) @PathVariable("fileId") UUID fileId,
        @Parameter(name = "MoveProjectFileRequestDto", description = "", required = true) @Valid @RequestBody MoveProjectFileRequestDto moveProjectFileRequestDto
    );


    /**
     * PUT /configuration/{projectId}/compound
     * Update mia compound
     *
     * @param projectId Project ID (required)
     * @param compoundDto request (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateCompound",
        description = "Update mia compound",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompoundDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/configuration/{projectId}/compound",
        produces = { "application/json" },
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<CompoundDto> updateCompound(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "CompoundDto", description = "request", required = true) @Valid @RequestBody CompoundDto compoundDto
    );


    /**
     * PUT /configuration/{projectId}
     * Update mia configuration
     *
     * @param projectId Project ID (required)
     * @param projectConfigurationDto request (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateConfiguration",
        description = "Update mia configuration",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectConfigurationDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/configuration/{projectId}",
        produces = { "application/json" },
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<ProjectConfigurationDto> updateConfiguration(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "ProjectConfigurationDto", description = "request", required = true) @Valid @RequestBody ProjectConfigurationDto projectConfigurationDto
    );


    /**
     * PUT /configuration/{projectId}/directory
     * Update mia directory
     *
     * @param projectId Project ID (required)
     * @param projectDirectoryDto request (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateDirectory",
        description = "Update mia directory",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/configuration/{projectId}/directory",
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<Void> updateDirectory(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "ProjectDirectoryDto", description = "request", required = true) @Valid @RequestBody ProjectDirectoryDto projectDirectoryDto
    );


    /**
     * PUT /configuration/{projectId}/process
     * Update mia process
     *
     * @param projectId Project ID (required)
     * @param processDto request (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateProcess",
        description = "Update mia process",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProcessDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/configuration/{projectId}/process",
        produces = { "application/json" },
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<ProcessDto> updateProcess(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "ProcessDto", description = "request", required = true) @Valid @RequestBody ProcessDto processDto
    );


    /**
     * PUT /configuration/{projectId}/projectFile
     * Update mia project file
     *
     * @param projectId Project ID (required)
     * @param projectFile  (required)
     * @param file file (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateProjectFile",
        description = "Update mia project file",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/configuration/{projectId}/projectFile",
        consumes = { "multipart/form-data" }
    )
    ResponseEntity<Void> updateProjectFile(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "projectFile", description = "", required = true) @Valid @RequestPart(value = "projectFile", required = true) ProjectFileDto projectFile,
        @Parameter(name = "file", description = "file") @RequestPart(value = "file", required = false) MultipartFile file
    );


    /**
     * PUT /configuration/{projectId}/section
     * Update mia section
     *
     * @param projectId Project ID (required)
     * @param sectionDto request (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateSection",
        description = "Update mia section",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", array = @ArraySchema(schema = @Schema(implementation = SectionsDto.class)))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/configuration/{projectId}/section",
        produces = { "application/json" },
        consumes = { "application/json; charset=UTF-8" }
    )
    ResponseEntity<List<SectionsDto>> updateSection(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "SectionDto", description = "request", required = true) @Valid @RequestBody SectionDto sectionDto
    );


    /**
     * POST /configuration/{projectId}/uploadZipConfig
     * Upload config as ZIP file
     *
     * @param projectId Project ID (required)
     * @param file file (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "uploadZipConfig",
        description = "Upload config as ZIP file",
        tags = { "mia-configuration-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Boolean.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/configuration/{projectId}/uploadZipConfig",
        produces = { "application/json" },
        consumes = { "multipart/form-data" }
    )
    ResponseEntity<Boolean> uploadZipConfig(
        @Parameter(name = "projectId", description = "Project ID", required = true, in = ParameterIn.PATH) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "file", description = "file", required = true) @RequestPart(value = "file", required = true) MultipartFile file
    );

}
