package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * AbstractCompareEntityDto
 */

@JsonIgnoreProperties(
  value = "entityType", // ignore manually set entityType, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the entityType to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "entityType", visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = CompoundHistoryChangeDto.class, name = "COMPOUND"),
  @JsonSubTypes.Type(value = FileHistoryChangeDto.class, name = "FILE"),
  @JsonSubTypes.Type(value = ProcessHistoryChangeDto.class, name = "PROCESS"),
  @JsonSubTypes.Type(value = ProjectConfigurationHistoryChangeDto.class, name = "PROJECTCONFIGURATION"),
  @JsonSubTypes.Type(value = SectionHistoryChangeDto.class, name = "SECTION")
})

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:29.935489577Z[Etc/UTC]")
public class AbstractCompareEntityDto {

  private Long createdWhen = null;

  private Long modifiedWhen = null;

  private String createdBy;

  private String modifiedBy;

  private HistoryItemTypeDto entityType;

  public AbstractCompareEntityDto createdWhen(Long createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  
  @Schema(name = "createdWhen", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("createdWhen")
  public Long getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(Long createdWhen) {
    this.createdWhen = createdWhen;
  }

  public AbstractCompareEntityDto modifiedWhen(Long modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  
  @Schema(name = "modifiedWhen", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("modifiedWhen")
  public Long getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(Long modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public AbstractCompareEntityDto createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  
  @Schema(name = "createdBy", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("createdBy")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public AbstractCompareEntityDto modifiedBy(String modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  
  @Schema(name = "modifiedBy", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("modifiedBy")
  public String getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(String modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public AbstractCompareEntityDto entityType(HistoryItemTypeDto entityType) {
    this.entityType = entityType;
    return this;
  }

  /**
   * Get entityType
   * @return entityType
  */
  @Valid 
  @Schema(name = "entityType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("entityType")
  public HistoryItemTypeDto getEntityType() {
    return entityType;
  }

  public void setEntityType(HistoryItemTypeDto entityType) {
    this.entityType = entityType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AbstractCompareEntityDto abstractCompareEntity = (AbstractCompareEntityDto) o;
    return Objects.equals(this.createdWhen, abstractCompareEntity.createdWhen) &&
        Objects.equals(this.modifiedWhen, abstractCompareEntity.modifiedWhen) &&
        Objects.equals(this.createdBy, abstractCompareEntity.createdBy) &&
        Objects.equals(this.modifiedBy, abstractCompareEntity.modifiedBy) &&
        Objects.equals(this.entityType, abstractCompareEntity.entityType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdWhen, modifiedWhen, createdBy, modifiedBy, entityType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AbstractCompareEntityDto {\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

