package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.LinkDto;
import org.qubership.atp.mia.controllers.api.dto.MarkedContentDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CommandOutputDto
 */

@JsonTypeName("CommandOutput")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:29.325137504Z[Etc/UTC]")
public class CommandOutputDto {

  private String internalPathToFile;

  private String externalPathToFile;

  private LinkDto link;

  private Boolean displayed;

  @Valid
  private List<String> content;

  @Valid
  private List<@Valid MarkedContentDto> markedContent;

  private Boolean isSizeExceedLimit;

  public CommandOutputDto internalPathToFile(String internalPathToFile) {
    this.internalPathToFile = internalPathToFile;
    return this;
  }

  /**
   * Get internalPathToFile
   * @return internalPathToFile
  */
  
  @Schema(name = "internalPathToFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("internalPathToFile")
  public String getInternalPathToFile() {
    return internalPathToFile;
  }

  public void setInternalPathToFile(String internalPathToFile) {
    this.internalPathToFile = internalPathToFile;
  }

  public CommandOutputDto externalPathToFile(String externalPathToFile) {
    this.externalPathToFile = externalPathToFile;
    return this;
  }

  /**
   * Get externalPathToFile
   * @return externalPathToFile
  */
  
  @Schema(name = "externalPathToFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("externalPathToFile")
  public String getExternalPathToFile() {
    return externalPathToFile;
  }

  public void setExternalPathToFile(String externalPathToFile) {
    this.externalPathToFile = externalPathToFile;
  }

  public CommandOutputDto link(LinkDto link) {
    this.link = link;
    return this;
  }

  /**
   * Get link
   * @return link
  */
  @Valid 
  @Schema(name = "link", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("link")
  public LinkDto getLink() {
    return link;
  }

  public void setLink(LinkDto link) {
    this.link = link;
  }

  public CommandOutputDto displayed(Boolean displayed) {
    this.displayed = displayed;
    return this;
  }

  /**
   * Get displayed
   * @return displayed
  */
  
  @Schema(name = "displayed", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("displayed")
  public Boolean getDisplayed() {
    return displayed;
  }

  public void setDisplayed(Boolean displayed) {
    this.displayed = displayed;
  }

  public CommandOutputDto content(List<String> content) {
    this.content = content;
    return this;
  }

  public CommandOutputDto addContentItem(String contentItem) {
    if (this.content == null) {
      this.content = new ArrayList<>();
    }
    this.content.add(contentItem);
    return this;
  }

  /**
   * Get content
   * @return content
  */
  
  @Schema(name = "content", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("content")
  public List<String> getContent() {
    return content;
  }

  public void setContent(List<String> content) {
    this.content = content;
  }

  public CommandOutputDto markedContent(List<@Valid MarkedContentDto> markedContent) {
    this.markedContent = markedContent;
    return this;
  }

  public CommandOutputDto addMarkedContentItem(MarkedContentDto markedContentItem) {
    if (this.markedContent == null) {
      this.markedContent = new ArrayList<>();
    }
    this.markedContent.add(markedContentItem);
    return this;
  }

  /**
   * Get markedContent
   * @return markedContent
  */
  @Valid 
  @Schema(name = "markedContent", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("markedContent")
  public List<@Valid MarkedContentDto> getMarkedContent() {
    return markedContent;
  }

  public void setMarkedContent(List<@Valid MarkedContentDto> markedContent) {
    this.markedContent = markedContent;
  }

  public CommandOutputDto isSizeExceedLimit(Boolean isSizeExceedLimit) {
    this.isSizeExceedLimit = isSizeExceedLimit;
    return this;
  }

  /**
   * Get isSizeExceedLimit
   * @return isSizeExceedLimit
  */
  
  @Schema(name = "isSizeExceedLimit", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("isSizeExceedLimit")
  public Boolean getIsSizeExceedLimit() {
    return isSizeExceedLimit;
  }

  public void setIsSizeExceedLimit(Boolean isSizeExceedLimit) {
    this.isSizeExceedLimit = isSizeExceedLimit;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommandOutputDto commandOutput = (CommandOutputDto) o;
    return Objects.equals(this.internalPathToFile, commandOutput.internalPathToFile) &&
        Objects.equals(this.externalPathToFile, commandOutput.externalPathToFile) &&
        Objects.equals(this.link, commandOutput.link) &&
        Objects.equals(this.displayed, commandOutput.displayed) &&
        Objects.equals(this.content, commandOutput.content) &&
        Objects.equals(this.markedContent, commandOutput.markedContent) &&
        Objects.equals(this.isSizeExceedLimit, commandOutput.isSizeExceedLimit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(internalPathToFile, externalPathToFile, link, displayed, content, markedContent, isSizeExceedLimit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommandOutputDto {\n");
    sb.append("    internalPathToFile: ").append(toIndentedString(internalPathToFile)).append("\n");
    sb.append("    externalPathToFile: ").append(toIndentedString(externalPathToFile)).append("\n");
    sb.append("    link: ").append(toIndentedString(link)).append("\n");
    sb.append("    displayed: ").append(toIndentedString(displayed)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    markedContent: ").append(toIndentedString(markedContent)).append("\n");
    sb.append("    isSizeExceedLimit: ").append(toIndentedString(isSizeExceedLimit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

