package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CommandPrefixDto
 */

@JsonTypeName("CommandPrefix")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:29.935489577Z[Etc/UTC]")
public class CommandPrefixDto {

  @Valid
  private Map<String, String> prefixes = new HashMap<>();

  private String system;

  public CommandPrefixDto prefixes(Map<String, String> prefixes) {
    this.prefixes = prefixes;
    return this;
  }

  public CommandPrefixDto putPrefixesItem(String key, String prefixesItem) {
    if (this.prefixes == null) {
      this.prefixes = new HashMap<>();
    }
    this.prefixes.put(key, prefixesItem);
    return this;
  }

  /**
   * Get prefixes
   * @return prefixes
  */
  
  @Schema(name = "prefixes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("prefixes")
  public Map<String, String> getPrefixes() {
    return prefixes;
  }

  public void setPrefixes(Map<String, String> prefixes) {
    this.prefixes = prefixes;
  }

  public CommandPrefixDto system(String system) {
    this.system = system;
    return this;
  }

  /**
   * Get system
   * @return system
  */
  
  @Schema(name = "system", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("system")
  public String getSystem() {
    return system;
  }

  public void setSystem(String system) {
    this.system = system;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommandPrefixDto commandPrefix = (CommandPrefixDto) o;
    return Objects.equals(this.prefixes, commandPrefix.prefixes) &&
        Objects.equals(this.system, commandPrefix.system);
  }

  @Override
  public int hashCode() {
    return Objects.hash(prefixes, system);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommandPrefixDto {\n");
    sb.append("    prefixes: ").append(toIndentedString(prefixes)).append("\n");
    sb.append("    system: ").append(toIndentedString(system)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

