package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.ProcessDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CompoundDto
 */

@JsonTypeName("Compound")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:29.325137504Z[Etc/UTC]")
public class CompoundDto {

  private UUID id;

  private String name;

  private String referToInput;

  @Valid
  private List<@Valid ProcessDto> processes;

  @Valid
  private List<UUID> inSections;

  /**
   * Default constructor
   * @deprecated Use {@link CompoundDto#CompoundDto(String)}
   */
  @Deprecated
  public CompoundDto() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public CompoundDto(String name) {
    this.name = name;
  }

  public CompoundDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public CompoundDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CompoundDto referToInput(String referToInput) {
    this.referToInput = referToInput;
    return this;
  }

  /**
   * Get referToInput
   * @return referToInput
  */
  
  @Schema(name = "referToInput", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("referToInput")
  public String getReferToInput() {
    return referToInput;
  }

  public void setReferToInput(String referToInput) {
    this.referToInput = referToInput;
  }

  public CompoundDto processes(List<@Valid ProcessDto> processes) {
    this.processes = processes;
    return this;
  }

  public CompoundDto addProcessesItem(ProcessDto processesItem) {
    if (this.processes == null) {
      this.processes = new ArrayList<>();
    }
    this.processes.add(processesItem);
    return this;
  }

  /**
   * Get processes
   * @return processes
  */
  @Valid 
  @Schema(name = "processes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processes")
  public List<@Valid ProcessDto> getProcesses() {
    return processes;
  }

  public void setProcesses(List<@Valid ProcessDto> processes) {
    this.processes = processes;
  }

  public CompoundDto inSections(List<UUID> inSections) {
    this.inSections = inSections;
    return this;
  }

  public CompoundDto addInSectionsItem(UUID inSectionsItem) {
    if (this.inSections == null) {
      this.inSections = new ArrayList<>();
    }
    this.inSections.add(inSectionsItem);
    return this;
  }

  /**
   * Get inSections
   * @return inSections
  */
  @Valid 
  @Schema(name = "inSections", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inSections")
  public List<UUID> getInSections() {
    return inSections;
  }

  public void setInSections(List<UUID> inSections) {
    this.inSections = inSections;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompoundDto compound = (CompoundDto) o;
    return Objects.equals(this.id, compound.id) &&
        Objects.equals(this.name, compound.name) &&
        Objects.equals(this.referToInput, compound.referToInput) &&
        Objects.equals(this.processes, compound.processes) &&
        Objects.equals(this.inSections, compound.inSections);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, referToInput, processes, inSections);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompoundDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    referToInput: ").append(toIndentedString(referToInput)).append("\n");
    sb.append("    processes: ").append(toIndentedString(processes)).append("\n");
    sb.append("    inSections: ").append(toIndentedString(inSections)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

