package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.StackTraceElementDto;
import org.qubership.atp.mia.controllers.api.dto.ThrowableDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ExceptionDto
 */

@JsonTypeName("Exception")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:29.325137504Z[Etc/UTC]")
public class ExceptionDto {

  private ThrowableDto cause;

  private String localizedMessage;

  private String message;

  @Valid
  private List<@Valid StackTraceElementDto> stackTrace;

  @Valid
  private List<@Valid ThrowableDto> suppressed;

  public ExceptionDto cause(ThrowableDto cause) {
    this.cause = cause;
    return this;
  }

  /**
   * Get cause
   * @return cause
  */
  @Valid 
  @Schema(name = "cause", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("cause")
  public ThrowableDto getCause() {
    return cause;
  }

  public void setCause(ThrowableDto cause) {
    this.cause = cause;
  }

  public ExceptionDto localizedMessage(String localizedMessage) {
    this.localizedMessage = localizedMessage;
    return this;
  }

  /**
   * Get localizedMessage
   * @return localizedMessage
  */
  
  @Schema(name = "localizedMessage", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("localizedMessage")
  public String getLocalizedMessage() {
    return localizedMessage;
  }

  public void setLocalizedMessage(String localizedMessage) {
    this.localizedMessage = localizedMessage;
  }

  public ExceptionDto message(String message) {
    this.message = message;
    return this;
  }

  /**
   * Get message
   * @return message
  */
  
  @Schema(name = "message", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public ExceptionDto stackTrace(List<@Valid StackTraceElementDto> stackTrace) {
    this.stackTrace = stackTrace;
    return this;
  }

  public ExceptionDto addStackTraceItem(StackTraceElementDto stackTraceItem) {
    if (this.stackTrace == null) {
      this.stackTrace = new ArrayList<>();
    }
    this.stackTrace.add(stackTraceItem);
    return this;
  }

  /**
   * Get stackTrace
   * @return stackTrace
  */
  @Valid 
  @Schema(name = "stackTrace", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("stackTrace")
  public List<@Valid StackTraceElementDto> getStackTrace() {
    return stackTrace;
  }

  public void setStackTrace(List<@Valid StackTraceElementDto> stackTrace) {
    this.stackTrace = stackTrace;
  }

  public ExceptionDto suppressed(List<@Valid ThrowableDto> suppressed) {
    this.suppressed = suppressed;
    return this;
  }

  public ExceptionDto addSuppressedItem(ThrowableDto suppressedItem) {
    if (this.suppressed == null) {
      this.suppressed = new ArrayList<>();
    }
    this.suppressed.add(suppressedItem);
    return this;
  }

  /**
   * Get suppressed
   * @return suppressed
  */
  @Valid 
  @Schema(name = "suppressed", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("suppressed")
  public List<@Valid ThrowableDto> getSuppressed() {
    return suppressed;
  }

  public void setSuppressed(List<@Valid ThrowableDto> suppressed) {
    this.suppressed = suppressed;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExceptionDto exception = (ExceptionDto) o;
    return Objects.equals(this.cause, exception.cause) &&
        Objects.equals(this.localizedMessage, exception.localizedMessage) &&
        Objects.equals(this.message, exception.message) &&
        Objects.equals(this.stackTrace, exception.stackTrace) &&
        Objects.equals(this.suppressed, exception.suppressed);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cause, localizedMessage, message, stackTrace, suppressed);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExceptionDto {\n");
    sb.append("    cause: ").append(toIndentedString(cause)).append("\n");
    sb.append("    localizedMessage: ").append(toIndentedString(localizedMessage)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    stackTrace: ").append(toIndentedString(stackTrace)).append("\n");
    sb.append("    suppressed: ").append(toIndentedString(suppressed)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

