package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import org.qubership.atp.mia.controllers.api.dto.CommonConfigurationDto;
import org.qubership.atp.mia.controllers.api.dto.TestDataWorkbookDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * FlowDataDto
 */

@JsonTypeName("FlowData")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:29.325137504Z[Etc/UTC]")
public class FlowDataDto {

  private String projectId;

  @Valid
  private Map<String, String> parameters = new HashMap<>();

  private CommonConfigurationDto commonConfiguration;

  private TestDataWorkbookDto testDataWorkbook;

  public FlowDataDto projectId(String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  
  @Schema(name = "projectId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("projectId")
  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public FlowDataDto parameters(Map<String, String> parameters) {
    this.parameters = parameters;
    return this;
  }

  public FlowDataDto putParametersItem(String key, String parametersItem) {
    if (this.parameters == null) {
      this.parameters = new HashMap<>();
    }
    this.parameters.put(key, parametersItem);
    return this;
  }

  /**
   * Get parameters
   * @return parameters
  */
  
  @Schema(name = "parameters", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parameters")
  public Map<String, String> getParameters() {
    return parameters;
  }

  public void setParameters(Map<String, String> parameters) {
    this.parameters = parameters;
  }

  public FlowDataDto commonConfiguration(CommonConfigurationDto commonConfiguration) {
    this.commonConfiguration = commonConfiguration;
    return this;
  }

  /**
   * Get commonConfiguration
   * @return commonConfiguration
  */
  @Valid 
  @Schema(name = "commonConfiguration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("commonConfiguration")
  public CommonConfigurationDto getCommonConfiguration() {
    return commonConfiguration;
  }

  public void setCommonConfiguration(CommonConfigurationDto commonConfiguration) {
    this.commonConfiguration = commonConfiguration;
  }

  public FlowDataDto testDataWorkbook(TestDataWorkbookDto testDataWorkbook) {
    this.testDataWorkbook = testDataWorkbook;
    return this;
  }

  /**
   * Get testDataWorkbook
   * @return testDataWorkbook
  */
  @Valid 
  @Schema(name = "testDataWorkbook", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("testDataWorkbook")
  public TestDataWorkbookDto getTestDataWorkbook() {
    return testDataWorkbook;
  }

  public void setTestDataWorkbook(TestDataWorkbookDto testDataWorkbook) {
    this.testDataWorkbook = testDataWorkbook;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FlowDataDto flowData = (FlowDataDto) o;
    return Objects.equals(this.projectId, flowData.projectId) &&
        Objects.equals(this.parameters, flowData.parameters) &&
        Objects.equals(this.commonConfiguration, flowData.commonConfiguration) &&
        Objects.equals(this.testDataWorkbook, flowData.testDataWorkbook);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectId, parameters, commonConfiguration, testDataWorkbook);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FlowDataDto {\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    commonConfiguration: ").append(toIndentedString(commonConfiguration)).append("\n");
    sb.append("    testDataWorkbook: ").append(toIndentedString(testDataWorkbook)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

