package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.AbstractCompareEntityDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessSettingsDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProcessHistoryChangeDto
 */


@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:29.935489577Z[Etc/UTC]")
public class ProcessHistoryChangeDto extends AbstractCompareEntityDto {

  private UUID id;

  private String name;

  private ProcessSettingsDto processSettings;

  @Valid
  private List<String> inSections;

  @Valid
  private List<String> inCompounds;

  /**
   * Default constructor
   * @deprecated Use {@link ProcessHistoryChangeDto#ProcessHistoryChangeDto(String)}
   */
  @Deprecated
  public ProcessHistoryChangeDto() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ProcessHistoryChangeDto(String name) {
    super();
    this.name = name;
  }

  public ProcessHistoryChangeDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ProcessHistoryChangeDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ProcessHistoryChangeDto processSettings(ProcessSettingsDto processSettings) {
    this.processSettings = processSettings;
    return this;
  }

  /**
   * Get processSettings
   * @return processSettings
  */
  @Valid 
  @Schema(name = "processSettings", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processSettings")
  public ProcessSettingsDto getProcessSettings() {
    return processSettings;
  }

  public void setProcessSettings(ProcessSettingsDto processSettings) {
    this.processSettings = processSettings;
  }

  public ProcessHistoryChangeDto inSections(List<String> inSections) {
    this.inSections = inSections;
    return this;
  }

  public ProcessHistoryChangeDto addInSectionsItem(String inSectionsItem) {
    if (this.inSections == null) {
      this.inSections = new ArrayList<>();
    }
    this.inSections.add(inSectionsItem);
    return this;
  }

  /**
   * Get inSections
   * @return inSections
  */
  
  @Schema(name = "inSections", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inSections")
  public List<String> getInSections() {
    return inSections;
  }

  public void setInSections(List<String> inSections) {
    this.inSections = inSections;
  }

  public ProcessHistoryChangeDto inCompounds(List<String> inCompounds) {
    this.inCompounds = inCompounds;
    return this;
  }

  public ProcessHistoryChangeDto addInCompoundsItem(String inCompoundsItem) {
    if (this.inCompounds == null) {
      this.inCompounds = new ArrayList<>();
    }
    this.inCompounds.add(inCompoundsItem);
    return this;
  }

  /**
   * Get inCompounds
   * @return inCompounds
  */
  
  @Schema(name = "inCompounds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inCompounds")
  public List<String> getInCompounds() {
    return inCompounds;
  }

  public void setInCompounds(List<String> inCompounds) {
    this.inCompounds = inCompounds;
  }

  public ProcessHistoryChangeDto createdWhen(Long createdWhen) {
    super.setCreatedWhen(createdWhen);
    return this;
  }

  public ProcessHistoryChangeDto modifiedWhen(Long modifiedWhen) {
    super.setModifiedWhen(modifiedWhen);
    return this;
  }

  public ProcessHistoryChangeDto createdBy(String createdBy) {
    super.setCreatedBy(createdBy);
    return this;
  }

  public ProcessHistoryChangeDto modifiedBy(String modifiedBy) {
    super.setModifiedBy(modifiedBy);
    return this;
  }

  public ProcessHistoryChangeDto entityType(HistoryItemTypeDto entityType) {
    super.setEntityType(entityType);
    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessHistoryChangeDto processHistoryChange = (ProcessHistoryChangeDto) o;
    return Objects.equals(this.id, processHistoryChange.id) &&
        Objects.equals(this.name, processHistoryChange.name) &&
        Objects.equals(this.processSettings, processHistoryChange.processSettings) &&
        Objects.equals(this.inSections, processHistoryChange.inSections) &&
        Objects.equals(this.inCompounds, processHistoryChange.inCompounds) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, processSettings, inSections, inCompounds, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessHistoryChangeDto {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    processSettings: ").append(toIndentedString(processSettings)).append("\n");
    sb.append("    inSections: ").append(toIndentedString(inSections)).append("\n");
    sb.append("    inCompounds: ").append(toIndentedString(inCompounds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

