package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.RestLoopParametersDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * RestDto
 */

@JsonTypeName("Rest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:39:29.935489577Z[Etc/UTC]")
public class RestDto {

  private String restFile;

  private String endpoint;

  private String method;

  private String headers;

  private String body;

  private String bodyFile;

  private Boolean parseResponseAsTable;

  private Boolean hasFile;

  private Boolean disableRedirect;

  private Boolean saveCookie;

  private RestLoopParametersDto restLoopParameters;

  private Boolean checkStatusCodeFlag;

  @Valid
  private List<String> checkStatusCode;

  private String script;

  public RestDto restFile(String restFile) {
    this.restFile = restFile;
    return this;
  }

  /**
   * Get restFile
   * @return restFile
  */
  
  @Schema(name = "restFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("restFile")
  public String getRestFile() {
    return restFile;
  }

  public void setRestFile(String restFile) {
    this.restFile = restFile;
  }

  public RestDto endpoint(String endpoint) {
    this.endpoint = endpoint;
    return this;
  }

  /**
   * Get endpoint
   * @return endpoint
  */
  
  @Schema(name = "endpoint", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("endpoint")
  public String getEndpoint() {
    return endpoint;
  }

  public void setEndpoint(String endpoint) {
    this.endpoint = endpoint;
  }

  public RestDto method(String method) {
    this.method = method;
    return this;
  }

  /**
   * Get method
   * @return method
  */
  
  @Schema(name = "method", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("method")
  public String getMethod() {
    return method;
  }

  public void setMethod(String method) {
    this.method = method;
  }

  public RestDto headers(String headers) {
    this.headers = headers;
    return this;
  }

  /**
   * Get headers
   * @return headers
  */
  
  @Schema(name = "headers", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("headers")
  public String getHeaders() {
    return headers;
  }

  public void setHeaders(String headers) {
    this.headers = headers;
  }

  public RestDto body(String body) {
    this.body = body;
    return this;
  }

  /**
   * Get body
   * @return body
  */
  
  @Schema(name = "body", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("body")
  public String getBody() {
    return body;
  }

  public void setBody(String body) {
    this.body = body;
  }

  public RestDto bodyFile(String bodyFile) {
    this.bodyFile = bodyFile;
    return this;
  }

  /**
   * Get bodyFile
   * @return bodyFile
  */
  
  @Schema(name = "bodyFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("bodyFile")
  public String getBodyFile() {
    return bodyFile;
  }

  public void setBodyFile(String bodyFile) {
    this.bodyFile = bodyFile;
  }

  public RestDto parseResponseAsTable(Boolean parseResponseAsTable) {
    this.parseResponseAsTable = parseResponseAsTable;
    return this;
  }

  /**
   * Get parseResponseAsTable
   * @return parseResponseAsTable
  */
  
  @Schema(name = "parseResponseAsTable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parseResponseAsTable")
  public Boolean getParseResponseAsTable() {
    return parseResponseAsTable;
  }

  public void setParseResponseAsTable(Boolean parseResponseAsTable) {
    this.parseResponseAsTable = parseResponseAsTable;
  }

  public RestDto hasFile(Boolean hasFile) {
    this.hasFile = hasFile;
    return this;
  }

  /**
   * Get hasFile
   * @return hasFile
  */
  
  @Schema(name = "hasFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hasFile")
  public Boolean getHasFile() {
    return hasFile;
  }

  public void setHasFile(Boolean hasFile) {
    this.hasFile = hasFile;
  }

  public RestDto disableRedirect(Boolean disableRedirect) {
    this.disableRedirect = disableRedirect;
    return this;
  }

  /**
   * Get disableRedirect
   * @return disableRedirect
  */
  
  @Schema(name = "disableRedirect", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("disableRedirect")
  public Boolean getDisableRedirect() {
    return disableRedirect;
  }

  public void setDisableRedirect(Boolean disableRedirect) {
    this.disableRedirect = disableRedirect;
  }

  public RestDto saveCookie(Boolean saveCookie) {
    this.saveCookie = saveCookie;
    return this;
  }

  /**
   * Get saveCookie
   * @return saveCookie
  */
  
  @Schema(name = "saveCookie", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("saveCookie")
  public Boolean getSaveCookie() {
    return saveCookie;
  }

  public void setSaveCookie(Boolean saveCookie) {
    this.saveCookie = saveCookie;
  }

  public RestDto restLoopParameters(RestLoopParametersDto restLoopParameters) {
    this.restLoopParameters = restLoopParameters;
    return this;
  }

  /**
   * Get restLoopParameters
   * @return restLoopParameters
  */
  @Valid 
  @Schema(name = "restLoopParameters", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("restLoopParameters")
  public RestLoopParametersDto getRestLoopParameters() {
    return restLoopParameters;
  }

  public void setRestLoopParameters(RestLoopParametersDto restLoopParameters) {
    this.restLoopParameters = restLoopParameters;
  }

  public RestDto checkStatusCodeFlag(Boolean checkStatusCodeFlag) {
    this.checkStatusCodeFlag = checkStatusCodeFlag;
    return this;
  }

  /**
   * Get checkStatusCodeFlag
   * @return checkStatusCodeFlag
  */
  
  @Schema(name = "checkStatusCodeFlag", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("checkStatusCodeFlag")
  public Boolean getCheckStatusCodeFlag() {
    return checkStatusCodeFlag;
  }

  public void setCheckStatusCodeFlag(Boolean checkStatusCodeFlag) {
    this.checkStatusCodeFlag = checkStatusCodeFlag;
  }

  public RestDto checkStatusCode(List<String> checkStatusCode) {
    this.checkStatusCode = checkStatusCode;
    return this;
  }

  public RestDto addCheckStatusCodeItem(String checkStatusCodeItem) {
    if (this.checkStatusCode == null) {
      this.checkStatusCode = new ArrayList<>();
    }
    this.checkStatusCode.add(checkStatusCodeItem);
    return this;
  }

  /**
   * Get checkStatusCode
   * @return checkStatusCode
  */
  
  @Schema(name = "checkStatusCode", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("checkStatusCode")
  public List<String> getCheckStatusCode() {
    return checkStatusCode;
  }

  public void setCheckStatusCode(List<String> checkStatusCode) {
    this.checkStatusCode = checkStatusCode;
  }

  public RestDto script(String script) {
    this.script = script;
    return this;
  }

  /**
   * Get script
   * @return script
  */
  
  @Schema(name = "script", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("script")
  public String getScript() {
    return script;
  }

  public void setScript(String script) {
    this.script = script;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RestDto rest = (RestDto) o;
    return Objects.equals(this.restFile, rest.restFile) &&
        Objects.equals(this.endpoint, rest.endpoint) &&
        Objects.equals(this.method, rest.method) &&
        Objects.equals(this.headers, rest.headers) &&
        Objects.equals(this.body, rest.body) &&
        Objects.equals(this.bodyFile, rest.bodyFile) &&
        Objects.equals(this.parseResponseAsTable, rest.parseResponseAsTable) &&
        Objects.equals(this.hasFile, rest.hasFile) &&
        Objects.equals(this.disableRedirect, rest.disableRedirect) &&
        Objects.equals(this.saveCookie, rest.saveCookie) &&
        Objects.equals(this.restLoopParameters, rest.restLoopParameters) &&
        Objects.equals(this.checkStatusCodeFlag, rest.checkStatusCodeFlag) &&
        Objects.equals(this.checkStatusCode, rest.checkStatusCode) &&
        Objects.equals(this.script, rest.script);
  }

  @Override
  public int hashCode() {
    return Objects.hash(restFile, endpoint, method, headers, body, bodyFile, parseResponseAsTable, hasFile, disableRedirect, saveCookie, restLoopParameters, checkStatusCodeFlag, checkStatusCode, script);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RestDto {\n");
    sb.append("    restFile: ").append(toIndentedString(restFile)).append("\n");
    sb.append("    endpoint: ").append(toIndentedString(endpoint)).append("\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    bodyFile: ").append(toIndentedString(bodyFile)).append("\n");
    sb.append("    parseResponseAsTable: ").append(toIndentedString(parseResponseAsTable)).append("\n");
    sb.append("    hasFile: ").append(toIndentedString(hasFile)).append("\n");
    sb.append("    disableRedirect: ").append(toIndentedString(disableRedirect)).append("\n");
    sb.append("    saveCookie: ").append(toIndentedString(saveCookie)).append("\n");
    sb.append("    restLoopParameters: ").append(toIndentedString(restLoopParameters)).append("\n");
    sb.append("    checkStatusCodeFlag: ").append(toIndentedString(checkStatusCodeFlag)).append("\n");
    sb.append("    checkStatusCode: ").append(toIndentedString(checkStatusCode)).append("\n");
    sb.append("    script: ").append(toIndentedString(script)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

