package org.qubership.atp.mia.clients.api.environments.dto.projects;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.mia.clients.api.environments.dto.projects.ParametersGettingVersionDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * SystemResDto
 */

@JsonTypeName("SystemRes")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T06:34:45.094788524Z[Etc/UTC]")
public class SystemResDto implements Serializable {

  private static final long serialVersionUID = 1L;

  @Valid
  private List<Object> connections;

  private Long created;

  private UUID createdBy;

  private Long dateOfCheckVersion;

  private Long dateOfLastCheck;

  private String description;

  @Valid
  private List<Object> environmentIds;

  @Valid
  private List<Object> environments;

  private String externalName;

  private UUID externalId;

  private UUID id;

  private UUID linkToSystemId;

  private Boolean mergeByName;

  private Long modified;

  private UUID modifiedBy;

  private String name;

  private ParametersGettingVersionDto parametersGettingVersion;

  private UUID parentSystemId;

  private Object serverITF;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    FAIL("FAIL"),
    
    NOTHING("NOTHING"),
    
    PASS("PASS"),
    
    WARN("WARN");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private StatusEnum status;

  private Object systemCategory;

  private UUID systemCategoryId;

  private String version;

  public SystemResDto connections(List<Object> connections) {
    this.connections = connections;
    return this;
  }

  public SystemResDto addConnectionsItem(Object connectionsItem) {
    if (this.connections == null) {
      this.connections = new ArrayList<>();
    }
    this.connections.add(connectionsItem);
    return this;
  }

  /**
   * Get connections
   * @return connections
  */
  
  @Schema(name = "connections", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("connections")
  public List<Object> getConnections() {
    return connections;
  }

  public void setConnections(List<Object> connections) {
    this.connections = connections;
  }

  public SystemResDto created(Long created) {
    this.created = created;
    return this;
  }

  /**
   * Get created
   * @return created
  */
  
  @Schema(name = "created", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("created")
  public Long getCreated() {
    return created;
  }

  public void setCreated(Long created) {
    this.created = created;
  }

  public SystemResDto createdBy(UUID createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("createdBy")
  public UUID getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UUID createdBy) {
    this.createdBy = createdBy;
  }

  public SystemResDto dateOfCheckVersion(Long dateOfCheckVersion) {
    this.dateOfCheckVersion = dateOfCheckVersion;
    return this;
  }

  /**
   * Get dateOfCheckVersion
   * @return dateOfCheckVersion
  */
  
  @Schema(name = "dateOfCheckVersion", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("dateOfCheckVersion")
  public Long getDateOfCheckVersion() {
    return dateOfCheckVersion;
  }

  public void setDateOfCheckVersion(Long dateOfCheckVersion) {
    this.dateOfCheckVersion = dateOfCheckVersion;
  }

  public SystemResDto dateOfLastCheck(Long dateOfLastCheck) {
    this.dateOfLastCheck = dateOfLastCheck;
    return this;
  }

  /**
   * Get dateOfLastCheck
   * @return dateOfLastCheck
  */
  
  @Schema(name = "dateOfLastCheck", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("dateOfLastCheck")
  public Long getDateOfLastCheck() {
    return dateOfLastCheck;
  }

  public void setDateOfLastCheck(Long dateOfLastCheck) {
    this.dateOfLastCheck = dateOfLastCheck;
  }

  public SystemResDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public SystemResDto environmentIds(List<Object> environmentIds) {
    this.environmentIds = environmentIds;
    return this;
  }

  public SystemResDto addEnvironmentIdsItem(Object environmentIdsItem) {
    if (this.environmentIds == null) {
      this.environmentIds = new ArrayList<>();
    }
    this.environmentIds.add(environmentIdsItem);
    return this;
  }

  /**
   * Get environmentIds
   * @return environmentIds
  */
  
  @Schema(name = "environmentIds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("environmentIds")
  public List<Object> getEnvironmentIds() {
    return environmentIds;
  }

  public void setEnvironmentIds(List<Object> environmentIds) {
    this.environmentIds = environmentIds;
  }

  public SystemResDto environments(List<Object> environments) {
    this.environments = environments;
    return this;
  }

  public SystemResDto addEnvironmentsItem(Object environmentsItem) {
    if (this.environments == null) {
      this.environments = new ArrayList<>();
    }
    this.environments.add(environmentsItem);
    return this;
  }

  /**
   * Get environments
   * @return environments
  */
  
  @Schema(name = "environments", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("environments")
  public List<Object> getEnvironments() {
    return environments;
  }

  public void setEnvironments(List<Object> environments) {
    this.environments = environments;
  }

  public SystemResDto externalName(String externalName) {
    this.externalName = externalName;
    return this;
  }

  /**
   * Get externalName
   * @return externalName
  */
  
  @Schema(name = "externalName", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("externalName")
  public String getExternalName() {
    return externalName;
  }

  public void setExternalName(String externalName) {
    this.externalName = externalName;
  }

  public SystemResDto externalId(UUID externalId) {
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
  */
  @Valid 
  @Schema(name = "externalId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("externalId")
  public UUID getExternalId() {
    return externalId;
  }

  public void setExternalId(UUID externalId) {
    this.externalId = externalId;
  }

  public SystemResDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public SystemResDto linkToSystemId(UUID linkToSystemId) {
    this.linkToSystemId = linkToSystemId;
    return this;
  }

  /**
   * Get linkToSystemId
   * @return linkToSystemId
  */
  @Valid 
  @Schema(name = "linkToSystemId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("linkToSystemId")
  public UUID getLinkToSystemId() {
    return linkToSystemId;
  }

  public void setLinkToSystemId(UUID linkToSystemId) {
    this.linkToSystemId = linkToSystemId;
  }

  public SystemResDto mergeByName(Boolean mergeByName) {
    this.mergeByName = mergeByName;
    return this;
  }

  /**
   * Get mergeByName
   * @return mergeByName
  */
  
  @Schema(name = "mergeByName", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("mergeByName")
  public Boolean getMergeByName() {
    return mergeByName;
  }

  public void setMergeByName(Boolean mergeByName) {
    this.mergeByName = mergeByName;
  }

  public SystemResDto modified(Long modified) {
    this.modified = modified;
    return this;
  }

  /**
   * Get modified
   * @return modified
  */
  
  @Schema(name = "modified", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("modified")
  public Long getModified() {
    return modified;
  }

  public void setModified(Long modified) {
    this.modified = modified;
  }

  public SystemResDto modifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("modifiedBy")
  public UUID getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UUID modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public SystemResDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SystemResDto parametersGettingVersion(ParametersGettingVersionDto parametersGettingVersion) {
    this.parametersGettingVersion = parametersGettingVersion;
    return this;
  }

  /**
   * Get parametersGettingVersion
   * @return parametersGettingVersion
  */
  @Valid 
  @Schema(name = "parametersGettingVersion", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parametersGettingVersion")
  public ParametersGettingVersionDto getParametersGettingVersion() {
    return parametersGettingVersion;
  }

  public void setParametersGettingVersion(ParametersGettingVersionDto parametersGettingVersion) {
    this.parametersGettingVersion = parametersGettingVersion;
  }

  public SystemResDto parentSystemId(UUID parentSystemId) {
    this.parentSystemId = parentSystemId;
    return this;
  }

  /**
   * Get parentSystemId
   * @return parentSystemId
  */
  @Valid 
  @Schema(name = "parentSystemId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parentSystemId")
  public UUID getParentSystemId() {
    return parentSystemId;
  }

  public void setParentSystemId(UUID parentSystemId) {
    this.parentSystemId = parentSystemId;
  }

  public SystemResDto serverITF(Object serverITF) {
    this.serverITF = serverITF;
    return this;
  }

  /**
   * Get serverITF
   * @return serverITF
  */
  
  @Schema(name = "serverITF", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("serverITF")
  public Object getServerITF() {
    return serverITF;
  }

  public void setServerITF(Object serverITF) {
    this.serverITF = serverITF;
  }

  public SystemResDto status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  
  @Schema(name = "status", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("status")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public SystemResDto systemCategory(Object systemCategory) {
    this.systemCategory = systemCategory;
    return this;
  }

  /**
   * Get systemCategory
   * @return systemCategory
  */
  
  @Schema(name = "systemCategory", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("systemCategory")
  public Object getSystemCategory() {
    return systemCategory;
  }

  public void setSystemCategory(Object systemCategory) {
    this.systemCategory = systemCategory;
  }

  public SystemResDto systemCategoryId(UUID systemCategoryId) {
    this.systemCategoryId = systemCategoryId;
    return this;
  }

  /**
   * Get systemCategoryId
   * @return systemCategoryId
  */
  @Valid 
  @Schema(name = "systemCategoryId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("systemCategoryId")
  public UUID getSystemCategoryId() {
    return systemCategoryId;
  }

  public void setSystemCategoryId(UUID systemCategoryId) {
    this.systemCategoryId = systemCategoryId;
  }

  public SystemResDto version(String version) {
    this.version = version;
    return this;
  }

  /**
   * Get version
   * @return version
  */
  
  @Schema(name = "version", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SystemResDto systemRes = (SystemResDto) o;
    return Objects.equals(this.connections, systemRes.connections) &&
        Objects.equals(this.created, systemRes.created) &&
        Objects.equals(this.createdBy, systemRes.createdBy) &&
        Objects.equals(this.dateOfCheckVersion, systemRes.dateOfCheckVersion) &&
        Objects.equals(this.dateOfLastCheck, systemRes.dateOfLastCheck) &&
        Objects.equals(this.description, systemRes.description) &&
        Objects.equals(this.environmentIds, systemRes.environmentIds) &&
        Objects.equals(this.environments, systemRes.environments) &&
        Objects.equals(this.externalName, systemRes.externalName) &&
        Objects.equals(this.externalId, systemRes.externalId) &&
        Objects.equals(this.id, systemRes.id) &&
        Objects.equals(this.linkToSystemId, systemRes.linkToSystemId) &&
        Objects.equals(this.mergeByName, systemRes.mergeByName) &&
        Objects.equals(this.modified, systemRes.modified) &&
        Objects.equals(this.modifiedBy, systemRes.modifiedBy) &&
        Objects.equals(this.name, systemRes.name) &&
        Objects.equals(this.parametersGettingVersion, systemRes.parametersGettingVersion) &&
        Objects.equals(this.parentSystemId, systemRes.parentSystemId) &&
        Objects.equals(this.serverITF, systemRes.serverITF) &&
        Objects.equals(this.status, systemRes.status) &&
        Objects.equals(this.systemCategory, systemRes.systemCategory) &&
        Objects.equals(this.systemCategoryId, systemRes.systemCategoryId) &&
        Objects.equals(this.version, systemRes.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(connections, created, createdBy, dateOfCheckVersion, dateOfLastCheck, description, environmentIds, environments, externalName, externalId, id, linkToSystemId, mergeByName, modified, modifiedBy, name, parametersGettingVersion, parentSystemId, serverITF, status, systemCategory, systemCategoryId, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SystemResDto {\n");
    sb.append("    connections: ").append(toIndentedString(connections)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    dateOfCheckVersion: ").append(toIndentedString(dateOfCheckVersion)).append("\n");
    sb.append("    dateOfLastCheck: ").append(toIndentedString(dateOfLastCheck)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    environmentIds: ").append(toIndentedString(environmentIds)).append("\n");
    sb.append("    environments: ").append(toIndentedString(environments)).append("\n");
    sb.append("    externalName: ").append(toIndentedString(externalName)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    linkToSystemId: ").append(toIndentedString(linkToSystemId)).append("\n");
    sb.append("    mergeByName: ").append(toIndentedString(mergeByName)).append("\n");
    sb.append("    modified: ").append(toIndentedString(modified)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parametersGettingVersion: ").append(toIndentedString(parametersGettingVersion)).append("\n");
    sb.append("    parentSystemId: ").append(toIndentedString(parentSystemId)).append("\n");
    sb.append("    serverITF: ").append(toIndentedString(serverITF)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    systemCategory: ").append(toIndentedString(systemCategory)).append("\n");
    sb.append("    systemCategoryId: ").append(toIndentedString(systemCategoryId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

