/*
 *  Copyright 2024-2025 NetCracker Technology Corporation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.qubership.atp.mia.config;

import org.qubership.atp.mia.service.cache.MiaCacheService;
import org.qubership.atp.mia.service.cache.MiaCacheServiceHazelCast;
import org.qubership.atp.mia.service.cache.MiaCacheServiceNoHazelCast;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableCaching
@Primary
public class CacheConfiguration {

    @Value("${spring.cache.hazelcast.client.enable:#{false}}")
    private boolean hazelcastClientEnabled;

    /**
     * Customizes cache manager.
     *
     * @return Cache manager
     */
    @Bean
    public CacheManager cacheManager(MiaCacheService miaCacheService) {
        return miaCacheService.cacheManager();
    }

    @Bean
    MiaCacheService getMiaCacheService() {
        if (hazelcastClientEnabled) {
            return new MiaCacheServiceHazelCast();
        }
        return new MiaCacheServiceNoHazelCast();
    }
}
