package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.AbstractCompareEntityDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DirectoryHistoryChangeDto
 */


@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T06:34:46.449159850Z[Etc/UTC]")
public class DirectoryHistoryChangeDto extends AbstractCompareEntityDto {

  private String name;

  private String parentDirectory;

  @Valid
  private List<String> childDirectories;

  @Valid
  private List<String> files;

  /**
   * Default constructor
   * @deprecated Use {@link DirectoryHistoryChangeDto#DirectoryHistoryChangeDto(String)}
   */
  @Deprecated
  public DirectoryHistoryChangeDto() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DirectoryHistoryChangeDto(String name) {
    super();
    this.name = name;
  }

  public DirectoryHistoryChangeDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DirectoryHistoryChangeDto parentDirectory(String parentDirectory) {
    this.parentDirectory = parentDirectory;
    return this;
  }

  /**
   * Get parentDirectory
   * @return parentDirectory
  */
  
  @Schema(name = "parentDirectory", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parentDirectory")
  public String getParentDirectory() {
    return parentDirectory;
  }

  public void setParentDirectory(String parentDirectory) {
    this.parentDirectory = parentDirectory;
  }

  public DirectoryHistoryChangeDto childDirectories(List<String> childDirectories) {
    this.childDirectories = childDirectories;
    return this;
  }

  public DirectoryHistoryChangeDto addChildDirectoriesItem(String childDirectoriesItem) {
    if (this.childDirectories == null) {
      this.childDirectories = new ArrayList<>();
    }
    this.childDirectories.add(childDirectoriesItem);
    return this;
  }

  /**
   * Get childDirectories
   * @return childDirectories
  */
  
  @Schema(name = "childDirectories", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("childDirectories")
  public List<String> getChildDirectories() {
    return childDirectories;
  }

  public void setChildDirectories(List<String> childDirectories) {
    this.childDirectories = childDirectories;
  }

  public DirectoryHistoryChangeDto files(List<String> files) {
    this.files = files;
    return this;
  }

  public DirectoryHistoryChangeDto addFilesItem(String filesItem) {
    if (this.files == null) {
      this.files = new ArrayList<>();
    }
    this.files.add(filesItem);
    return this;
  }

  /**
   * Get files
   * @return files
  */
  
  @Schema(name = "files", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("files")
  public List<String> getFiles() {
    return files;
  }

  public void setFiles(List<String> files) {
    this.files = files;
  }

  public DirectoryHistoryChangeDto createdWhen(Long createdWhen) {
    super.setCreatedWhen(createdWhen);
    return this;
  }

  public DirectoryHistoryChangeDto modifiedWhen(Long modifiedWhen) {
    super.setModifiedWhen(modifiedWhen);
    return this;
  }

  public DirectoryHistoryChangeDto createdBy(String createdBy) {
    super.setCreatedBy(createdBy);
    return this;
  }

  public DirectoryHistoryChangeDto modifiedBy(String modifiedBy) {
    super.setModifiedBy(modifiedBy);
    return this;
  }

  public DirectoryHistoryChangeDto entityType(HistoryItemTypeDto entityType) {
    super.setEntityType(entityType);
    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DirectoryHistoryChangeDto directoryHistoryChange = (DirectoryHistoryChangeDto) o;
    return Objects.equals(this.name, directoryHistoryChange.name) &&
        Objects.equals(this.parentDirectory, directoryHistoryChange.parentDirectory) &&
        Objects.equals(this.childDirectories, directoryHistoryChange.childDirectories) &&
        Objects.equals(this.files, directoryHistoryChange.files) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, parentDirectory, childDirectories, files, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DirectoryHistoryChangeDto {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    parentDirectory: ").append(toIndentedString(parentDirectory)).append("\n");
    sb.append("    childDirectories: ").append(toIndentedString(childDirectories)).append("\n");
    sb.append("    files: ").append(toIndentedString(files)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

