package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.CommandDto;
import org.qubership.atp.mia.controllers.api.dto.InputDto;
import org.qubership.atp.mia.controllers.api.dto.PrerequisiteDto;
import org.qubership.atp.mia.controllers.api.dto.ValidationDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ExecutableDto
 */

@JsonTypeName("Executable")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T06:34:47.493919762Z[Etc/UTC]")
public class ExecutableDto {

  private UUID id;

  private String name;

  private String execType;

  private String pathToFile;

  @Valid
  private List<@Valid PrerequisiteDto> prerequisites;

  private CommandDto command;

  @Valid
  private List<@Valid ValidationDto> validations;

  @Valid
  private Map<String, String> globalVariables = new HashMap<>();

  @Valid
  private List<@Valid InputDto> inputs;

  @Valid
  private List<@Valid ValidationDto> currentStatement;

  private String referToInput;

  @Valid
  private List<@Valid ExecutableDto> processList;

  public ExecutableDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ExecutableDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ExecutableDto execType(String execType) {
    this.execType = execType;
    return this;
  }

  /**
   * Get execType
   * @return execType
  */
  
  @Schema(name = "execType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("execType")
  public String getExecType() {
    return execType;
  }

  public void setExecType(String execType) {
    this.execType = execType;
  }

  public ExecutableDto pathToFile(String pathToFile) {
    this.pathToFile = pathToFile;
    return this;
  }

  /**
   * Get pathToFile
   * @return pathToFile
  */
  
  @Schema(name = "pathToFile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pathToFile")
  public String getPathToFile() {
    return pathToFile;
  }

  public void setPathToFile(String pathToFile) {
    this.pathToFile = pathToFile;
  }

  public ExecutableDto prerequisites(List<@Valid PrerequisiteDto> prerequisites) {
    this.prerequisites = prerequisites;
    return this;
  }

  public ExecutableDto addPrerequisitesItem(PrerequisiteDto prerequisitesItem) {
    if (this.prerequisites == null) {
      this.prerequisites = new ArrayList<>();
    }
    this.prerequisites.add(prerequisitesItem);
    return this;
  }

  /**
   * Get prerequisites
   * @return prerequisites
  */
  @Valid 
  @Schema(name = "prerequisites", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("prerequisites")
  public List<@Valid PrerequisiteDto> getPrerequisites() {
    return prerequisites;
  }

  public void setPrerequisites(List<@Valid PrerequisiteDto> prerequisites) {
    this.prerequisites = prerequisites;
  }

  public ExecutableDto command(CommandDto command) {
    this.command = command;
    return this;
  }

  /**
   * Get command
   * @return command
  */
  @Valid 
  @Schema(name = "command", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("command")
  public CommandDto getCommand() {
    return command;
  }

  public void setCommand(CommandDto command) {
    this.command = command;
  }

  public ExecutableDto validations(List<@Valid ValidationDto> validations) {
    this.validations = validations;
    return this;
  }

  public ExecutableDto addValidationsItem(ValidationDto validationsItem) {
    if (this.validations == null) {
      this.validations = new ArrayList<>();
    }
    this.validations.add(validationsItem);
    return this;
  }

  /**
   * Get validations
   * @return validations
  */
  @Valid 
  @Schema(name = "validations", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validations")
  public List<@Valid ValidationDto> getValidations() {
    return validations;
  }

  public void setValidations(List<@Valid ValidationDto> validations) {
    this.validations = validations;
  }

  public ExecutableDto globalVariables(Map<String, String> globalVariables) {
    this.globalVariables = globalVariables;
    return this;
  }

  public ExecutableDto putGlobalVariablesItem(String key, String globalVariablesItem) {
    if (this.globalVariables == null) {
      this.globalVariables = new HashMap<>();
    }
    this.globalVariables.put(key, globalVariablesItem);
    return this;
  }

  /**
   * Get globalVariables
   * @return globalVariables
  */
  
  @Schema(name = "globalVariables", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("globalVariables")
  public Map<String, String> getGlobalVariables() {
    return globalVariables;
  }

  public void setGlobalVariables(Map<String, String> globalVariables) {
    this.globalVariables = globalVariables;
  }

  public ExecutableDto inputs(List<@Valid InputDto> inputs) {
    this.inputs = inputs;
    return this;
  }

  public ExecutableDto addInputsItem(InputDto inputsItem) {
    if (this.inputs == null) {
      this.inputs = new ArrayList<>();
    }
    this.inputs.add(inputsItem);
    return this;
  }

  /**
   * Get inputs
   * @return inputs
  */
  @Valid 
  @Schema(name = "inputs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inputs")
  public List<@Valid InputDto> getInputs() {
    return inputs;
  }

  public void setInputs(List<@Valid InputDto> inputs) {
    this.inputs = inputs;
  }

  public ExecutableDto currentStatement(List<@Valid ValidationDto> currentStatement) {
    this.currentStatement = currentStatement;
    return this;
  }

  public ExecutableDto addCurrentStatementItem(ValidationDto currentStatementItem) {
    if (this.currentStatement == null) {
      this.currentStatement = new ArrayList<>();
    }
    this.currentStatement.add(currentStatementItem);
    return this;
  }

  /**
   * Get currentStatement
   * @return currentStatement
  */
  @Valid 
  @Schema(name = "currentStatement", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("currentStatement")
  public List<@Valid ValidationDto> getCurrentStatement() {
    return currentStatement;
  }

  public void setCurrentStatement(List<@Valid ValidationDto> currentStatement) {
    this.currentStatement = currentStatement;
  }

  public ExecutableDto referToInput(String referToInput) {
    this.referToInput = referToInput;
    return this;
  }

  /**
   * Get referToInput
   * @return referToInput
  */
  
  @Schema(name = "referToInput", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("referToInput")
  public String getReferToInput() {
    return referToInput;
  }

  public void setReferToInput(String referToInput) {
    this.referToInput = referToInput;
  }

  public ExecutableDto processList(List<@Valid ExecutableDto> processList) {
    this.processList = processList;
    return this;
  }

  public ExecutableDto addProcessListItem(ExecutableDto processListItem) {
    if (this.processList == null) {
      this.processList = new ArrayList<>();
    }
    this.processList.add(processListItem);
    return this;
  }

  /**
   * Get processList
   * @return processList
  */
  @Valid 
  @Schema(name = "processList", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processList")
  public List<@Valid ExecutableDto> getProcessList() {
    return processList;
  }

  public void setProcessList(List<@Valid ExecutableDto> processList) {
    this.processList = processList;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExecutableDto executable = (ExecutableDto) o;
    return Objects.equals(this.id, executable.id) &&
        Objects.equals(this.name, executable.name) &&
        Objects.equals(this.execType, executable.execType) &&
        Objects.equals(this.pathToFile, executable.pathToFile) &&
        Objects.equals(this.prerequisites, executable.prerequisites) &&
        Objects.equals(this.command, executable.command) &&
        Objects.equals(this.validations, executable.validations) &&
        Objects.equals(this.globalVariables, executable.globalVariables) &&
        Objects.equals(this.inputs, executable.inputs) &&
        Objects.equals(this.currentStatement, executable.currentStatement) &&
        Objects.equals(this.referToInput, executable.referToInput) &&
        Objects.equals(this.processList, executable.processList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, execType, pathToFile, prerequisites, command, validations, globalVariables, inputs, currentStatement, referToInput, processList);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExecutableDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    execType: ").append(toIndentedString(execType)).append("\n");
    sb.append("    pathToFile: ").append(toIndentedString(pathToFile)).append("\n");
    sb.append("    prerequisites: ").append(toIndentedString(prerequisites)).append("\n");
    sb.append("    command: ").append(toIndentedString(command)).append("\n");
    sb.append("    validations: ").append(toIndentedString(validations)).append("\n");
    sb.append("    globalVariables: ").append(toIndentedString(globalVariables)).append("\n");
    sb.append("    inputs: ").append(toIndentedString(inputs)).append("\n");
    sb.append("    currentStatement: ").append(toIndentedString(currentStatement)).append("\n");
    sb.append("    referToInput: ").append(toIndentedString(referToInput)).append("\n");
    sb.append("    processList: ").append(toIndentedString(processList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

