package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * HistoryItemDto
 */

@JsonTypeName("HistoryItem")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T06:34:49.113363471Z[Etc/UTC]")
public class HistoryItemDto {

  private HistoryItemTypeDto type;

  private Integer version;

  private String modifiedWhen;

  private String modifiedBy;

  @Valid
  private List<String> added;

  @Valid
  private List<String> deleted;

  @Valid
  private List<String> changed;

  public HistoryItemDto type(HistoryItemTypeDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public HistoryItemTypeDto getType() {
    return type;
  }

  public void setType(HistoryItemTypeDto type) {
    this.type = type;
  }

  public HistoryItemDto version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * commit number of current changes
   * minimum: 1
   * @return version
  */
  @Min(1) 
  @Schema(name = "version", description = "commit number of current changes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public HistoryItemDto modifiedWhen(String modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  
  @Schema(name = "modifiedWhen", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("modifiedWhen")
  public String getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(String modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public HistoryItemDto modifiedBy(String modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  
  @Schema(name = "modifiedBy", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("modifiedBy")
  public String getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(String modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public HistoryItemDto added(List<String> added) {
    this.added = added;
    return this;
  }

  public HistoryItemDto addAddedItem(String addedItem) {
    if (this.added == null) {
      this.added = new ArrayList<>();
    }
    this.added.add(addedItem);
    return this;
  }

  /**
   * Get added
   * @return added
  */
  
  @Schema(name = "added", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("added")
  public List<String> getAdded() {
    return added;
  }

  public void setAdded(List<String> added) {
    this.added = added;
  }

  public HistoryItemDto deleted(List<String> deleted) {
    this.deleted = deleted;
    return this;
  }

  public HistoryItemDto addDeletedItem(String deletedItem) {
    if (this.deleted == null) {
      this.deleted = new ArrayList<>();
    }
    this.deleted.add(deletedItem);
    return this;
  }

  /**
   * Get deleted
   * @return deleted
  */
  
  @Schema(name = "deleted", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("deleted")
  public List<String> getDeleted() {
    return deleted;
  }

  public void setDeleted(List<String> deleted) {
    this.deleted = deleted;
  }

  public HistoryItemDto changed(List<String> changed) {
    this.changed = changed;
    return this;
  }

  public HistoryItemDto addChangedItem(String changedItem) {
    if (this.changed == null) {
      this.changed = new ArrayList<>();
    }
    this.changed.add(changedItem);
    return this;
  }

  /**
   * Get changed
   * @return changed
  */
  
  @Schema(name = "changed", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("changed")
  public List<String> getChanged() {
    return changed;
  }

  public void setChanged(List<String> changed) {
    this.changed = changed;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoryItemDto historyItem = (HistoryItemDto) o;
    return Objects.equals(this.type, historyItem.type) &&
        Objects.equals(this.version, historyItem.version) &&
        Objects.equals(this.modifiedWhen, historyItem.modifiedWhen) &&
        Objects.equals(this.modifiedBy, historyItem.modifiedBy) &&
        Objects.equals(this.added, historyItem.added) &&
        Objects.equals(this.deleted, historyItem.deleted) &&
        Objects.equals(this.changed, historyItem.changed);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, version, modifiedWhen, modifiedBy, added, deleted, changed);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoryItemDto {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    added: ").append(toIndentedString(added)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    changed: ").append(toIndentedString(changed)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

