package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * MainSheetRecordDto
 */

@JsonTypeName("MainSheetRecord")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T06:34:48.437927154Z[Etc/UTC]")
public class MainSheetRecordDto {

  private String scenario;

  private String description;

  @Valid
  private Map<String, String> otherCells = new HashMap<>();

  public MainSheetRecordDto scenario(String scenario) {
    this.scenario = scenario;
    return this;
  }

  /**
   * Get scenario
   * @return scenario
  */
  
  @Schema(name = "scenario", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("scenario")
  public String getScenario() {
    return scenario;
  }

  public void setScenario(String scenario) {
    this.scenario = scenario;
  }

  public MainSheetRecordDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public MainSheetRecordDto otherCells(Map<String, String> otherCells) {
    this.otherCells = otherCells;
    return this;
  }

  public MainSheetRecordDto putOtherCellsItem(String key, String otherCellsItem) {
    if (this.otherCells == null) {
      this.otherCells = new HashMap<>();
    }
    this.otherCells.put(key, otherCellsItem);
    return this;
  }

  /**
   * Get otherCells
   * @return otherCells
  */
  
  @Schema(name = "otherCells", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("otherCells")
  public Map<String, String> getOtherCells() {
    return otherCells;
  }

  public void setOtherCells(Map<String, String> otherCells) {
    this.otherCells = otherCells;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MainSheetRecordDto mainSheetRecord = (MainSheetRecordDto) o;
    return Objects.equals(this.scenario, mainSheetRecord.scenario) &&
        Objects.equals(this.description, mainSheetRecord.description) &&
        Objects.equals(this.otherCells, mainSheetRecord.otherCells);
  }

  @Override
  public int hashCode() {
    return Objects.hash(scenario, description, otherCells);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MainSheetRecordDto {\n");
    sb.append("    scenario: ").append(toIndentedString(scenario)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    otherCells: ").append(toIndentedString(otherCells)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

