package org.qubership.atp.mia.controllers.api.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.math.BigDecimal;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProjectFileDto
 */

@JsonTypeName("ProjectFile")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-12T06:34:47.493919762Z[Etc/UTC]")
public class ProjectFileDto {

  private UUID id;

  private String name;

  private UUID directory;

  private String lastUpdateWhen;

  private String lastUpdateBy;

  private BigDecimal size;

  /**
   * Default constructor
   * @deprecated Use {@link ProjectFileDto#ProjectFileDto(String)}
   */
  @Deprecated
  public ProjectFileDto() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ProjectFileDto(String name) {
    this.name = name;
  }

  public ProjectFileDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ProjectFileDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ProjectFileDto directory(UUID directory) {
    this.directory = directory;
    return this;
  }

  /**
   * Get directory
   * @return directory
  */
  @Valid 
  @Schema(name = "directory", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("directory")
  public UUID getDirectory() {
    return directory;
  }

  public void setDirectory(UUID directory) {
    this.directory = directory;
  }

  public ProjectFileDto lastUpdateWhen(String lastUpdateWhen) {
    this.lastUpdateWhen = lastUpdateWhen;
    return this;
  }

  /**
   * Get lastUpdateWhen
   * @return lastUpdateWhen
  */
  
  @Schema(name = "lastUpdateWhen", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("lastUpdateWhen")
  public String getLastUpdateWhen() {
    return lastUpdateWhen;
  }

  public void setLastUpdateWhen(String lastUpdateWhen) {
    this.lastUpdateWhen = lastUpdateWhen;
  }

  public ProjectFileDto lastUpdateBy(String lastUpdateBy) {
    this.lastUpdateBy = lastUpdateBy;
    return this;
  }

  /**
   * Get lastUpdateBy
   * @return lastUpdateBy
  */
  
  @Schema(name = "lastUpdateBy", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("lastUpdateBy")
  public String getLastUpdateBy() {
    return lastUpdateBy;
  }

  public void setLastUpdateBy(String lastUpdateBy) {
    this.lastUpdateBy = lastUpdateBy;
  }

  public ProjectFileDto size(BigDecimal size) {
    this.size = size;
    return this;
  }

  /**
   * Get size
   * @return size
  */
  @Valid 
  @Schema(name = "size", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("size")
  public BigDecimal getSize() {
    return size;
  }

  public void setSize(BigDecimal size) {
    this.size = size;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectFileDto projectFile = (ProjectFileDto) o;
    return Objects.equals(this.id, projectFile.id) &&
        Objects.equals(this.name, projectFile.name) &&
        Objects.equals(this.directory, projectFile.directory) &&
        Objects.equals(this.lastUpdateWhen, projectFile.lastUpdateWhen) &&
        Objects.equals(this.lastUpdateBy, projectFile.lastUpdateBy) &&
        Objects.equals(this.size, projectFile.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, directory, lastUpdateWhen, lastUpdateBy, size);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectFileDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    directory: ").append(toIndentedString(directory)).append("\n");
    sb.append("    lastUpdateWhen: ").append(toIndentedString(lastUpdateWhen)).append("\n");
    sb.append("    lastUpdateBy: ").append(toIndentedString(lastUpdateBy)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

