/*
 *  Copyright 2024-2025 NetCracker Technology Corporation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.qubership.atp.mia.exceptions.history;

import static java.util.Objects.nonNull;

import java.util.Set;

import javax.validation.ConstraintViolation;

import org.qubership.atp.mia.exceptions.MiaException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR, reason = "MIA-2061")
public class MiaJaversReferenceInvalidException extends MiaException {

    public static final String DEFAULT_MESSAGE = "Error while working with history references";

    private Set<ConstraintViolation<Object>> violations;

    public MiaJaversReferenceInvalidException(Set<ConstraintViolation<Object>> violations) {
        super(DEFAULT_MESSAGE);
        this.violations = violations;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        violations.stream()
                .map(violation -> String.format(violation.getMessage(),
                        nonNull(violation.getPropertyPath()) ? violation.getPropertyPath().toString() : "",
                        nonNull(violation.getInvalidValue()) ? violation.getInvalidValue().toString() : ""))
                .forEach(violation -> {
                    sb.append(violation).append(" ");
                });
        return sb.toString();
    }
}
