/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.clients.api.environments;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.mia.clients.api.environments.dto.projects.ConnectionFullVer2ViewDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.EnvironmentDtoDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.EnvironmentNameViewDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.EnvironmentResDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.ProjectDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.ProjectDtoDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.ProjectFullVer1ViewDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.ProjectFullVer2ViewDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.ProjectImplDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.ProjectNameViewDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.ProjectSearchRequestDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.StatusDtoDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.SystemEnvironmentsViewDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.SystemFullVer2ViewDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="project-controller", description="Project Controller")
public interface ProjectControllerApi {
    @Operation(operationId="copy", summary="copy", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects/{projectId}/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ProjectDto> copy(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="ProjectDtoDto", description="") @Valid @RequestBody(required=false) ProjectDtoDto var2);

    @Operation(operationId="createEnvironment", summary="createEnvironment", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentResDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects/{projectId}/environments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentResDto> createEnvironment(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="EnvironmentDtoDto", description="") @Valid @RequestBody(required=false) EnvironmentDtoDto var2);

    @Operation(operationId="createProject", summary="create", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ProjectDto> createProject(@Parameter(name="ProjectImplDto", description="") @Valid @RequestBody(required=false) ProjectImplDto var1);

    @Operation(operationId="createTool", summary="createTool", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentResDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects/{projectId}/tools"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentResDto> createTool(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="EnvironmentDtoDto", description="") @Valid @RequestBody(required=false) EnvironmentDtoDto var2);

    @Operation(operationId="deleteProject", summary="delete", tags={"project-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/projects/{projectId}"})
    public ResponseEntity<Void> deleteProject(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getAllEnvironments", summary="getAllEnvironments", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EnvironmentResDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/all"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentResDto>> getAllEnvironments(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getAllProjects", summary="getAll", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ProjectFullVer2ViewDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects"}, produces={"application/json"})
    public ResponseEntity<List<ProjectFullVer2ViewDto>> getAllProjects(@Parameter(name="host", description="host", in=ParameterIn.QUERY) @Valid @RequestParam(value="host", required=false) String var1, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getAllShort", summary="getAllShort", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ProjectNameViewDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/short"}, produces={"application/json"})
    public ResponseEntity<List<ProjectNameViewDto>> getAllShort(@Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getAllShortSystemsOnProject", summary="Endpoint for getting list of systems on project by projectId", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SystemEnvironmentsViewDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/systems/short"}, produces={"application/json"})
    public ResponseEntity<List<SystemEnvironmentsViewDto>> getAllShortSystemsOnProject(@Parameter(name="projectId", description="Project id for getting system", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getAllShortWithUserAccess", summary="getAllShortWithAccess", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ProjectNameViewDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/shortWithAccess"}, produces={"application/json"})
    public ResponseEntity<List<ProjectNameViewDto>> getAllShortWithUserAccess(@Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getConnections", summary="getConnections", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ConnectionFullVer2ViewDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/connections"}, produces={"application/json"})
    public ResponseEntity<List<ConnectionFullVer2ViewDto>> getConnections(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getConnectionsName", summary="getConnectionsName", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/connections/name"}, produces={"application/json"})
    public ResponseEntity<List<String>> getConnectionsName(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getEnvironments", summary="getEnvironments", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EnvironmentResDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentResDto>> getEnvironments(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getEnvironmentsShort", summary="getEnvironmentsShort", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EnvironmentNameViewDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/short"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentNameViewDto>> getEnvironmentsShort(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getProject", summary="getProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer1ViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}"}, produces={"application/json"})
    public ResponseEntity<ProjectFullVer1ViewDto> getProject(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getProjectSystems", summary="getSystems", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SystemFullVer2ViewDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/systems"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer2ViewDto>> getProjectSystems(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="category", description="category", in=ParameterIn.QUERY) @Valid @RequestParam(value="category", required=false) String var2, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getProjectWithSpecifiedEnvironments", summary="getProjectWithSpecifiedEnvironments", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer1ViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/{environmentIds}"}, produces={"application/json"})
    public ResponseEntity<ProjectFullVer1ViewDto> getProjectWithSpecifiedEnvironments(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="environmentIds", description="environmentIds", required=true, in=ParameterIn.PATH) @PathVariable(value="environmentIds") List<UUID> var2, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getProjectsByRequest", summary="getProjectsByRequest", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ProjectFullVer2ViewDto.class)))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/projects/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<ProjectFullVer2ViewDto>> getProjectsByRequest(@Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var1, @Parameter(name="ProjectSearchRequestDto", description="") @Valid @RequestBody(required=false) ProjectSearchRequestDto var2);

    @Operation(operationId="getShortProject", summary="getShortProject", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer1ViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/short/{projectId}"}, produces={"application/json"})
    public ResponseEntity<ProjectFullVer1ViewDto> getShortProject(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getShortProjectByName", summary="getShortProjectByName", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectFullVer1ViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/short/name/{projectName}"}, produces={"application/json"})
    public ResponseEntity<ProjectFullVer1ViewDto> getShortProjectByName(@Parameter(name="projectName", description="projectName", required=true, in=ParameterIn.PATH) @PathVariable(value="projectName") String var1, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getSystemsName", summary="getSystemsName", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/environments/systems/name"}, produces={"application/json"})
    public ResponseEntity<List<String>> getSystemsName(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getTemporaryEnvironments", summary="getTemporaryEnvironments", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EnvironmentResDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/temporary/environments"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentResDto>> getTemporaryEnvironments(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getTools", summary="getTools", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EnvironmentResDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/tools"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentResDto>> getTools(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="full", description="full", in=ParameterIn.QUERY) @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getToolsShort", summary="getToolsShort", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EnvironmentNameViewDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/projects/{projectId}/tools/short"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentNameViewDto>> getToolsShort(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="updateProject", summary="update", tags={"project-controller"}, responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/projects"}, consumes={"application/json"})
    public ResponseEntity<Void> updateProject(@Parameter(name="ProjectDtoDto", description="") @Valid @RequestBody(required=false) ProjectDtoDto var1);

    @Operation(operationId="updateSystemStatuses", summary="updateSystemStatuses", tags={"project-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=Object.class)))}), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/projects/{projectId}/systems/status"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Object>> updateSystemStatuses(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="StatusDtoDto", description="") @Valid @RequestBody(required=false) List<StatusDtoDto> var2);
}

