/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers;

import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.mia.controllers.api.MiaCacheControllerApi;
import org.qubership.atp.mia.model.impl.request.ExecutionRequest;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.cache.MiaCacheService;
import org.qubership.atp.mia.service.execution.ProcessService;
import org.qubership.atp.mia.service.execution.SshExecutionHelperService;
import org.springframework.cache.CacheManager;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MiaCacheController
implements MiaCacheControllerApi {
    private final MiaCacheService miaCacheService;
    private final SshExecutionHelperService sshExecutionHelperService;
    private final ProcessService processService;
    private final MiaContext miaContext;
    private final CacheManager cacheManager;

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @AuditAction(auditAction="Reset DB Cache for project : {{#projectId}} for environment : {{#env}}")
    public ResponseEntity<Boolean> resetDbCache(UUID projectId, String env) {
        this.miaContext.setContext(ExecutionRequest.builder().sessionId(UUID.randomUUID()).build(), projectId, env);
        return ResponseEntity.ok((Object)this.processService.resetDbCache());
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @AuditAction(auditAction="Reset Environment Caches for project - {{#projectId}}")
    public ResponseEntity<Boolean> resetEnvironmentCaches(UUID projectId) {
        this.miaCacheService.clearEnvironmentsCache(this.cacheManager, projectId);
        this.sshExecutionHelperService.resetCache();
        return ResponseEntity.ok((Object)true);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    @AuditAction(auditAction="Reset Pool Cache for project - {{#projectId}}")
    public ResponseEntity<Boolean> resetPoolCache(UUID projectId) {
        this.sshExecutionHelperService.resetCache();
        return ResponseEntity.ok((Object)true);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, \"EXECUTE\")")
    public ResponseEntity<Boolean> resetConfigurationCache(UUID projectId) {
        this.miaCacheService.clearConfigurationCache(projectId);
        return ResponseEntity.ok((Object)true);
    }

    public MiaCacheController(MiaCacheService miaCacheService, SshExecutionHelperService sshExecutionHelperService, ProcessService processService, MiaContext miaContext, CacheManager cacheManager) {
        this.miaCacheService = miaCacheService;
        this.sshExecutionHelperService = sshExecutionHelperService;
        this.processService = processService;
        this.miaContext = miaContext;
        this.cacheManager = cacheManager;
    }
}

