/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.model.impl.request.ExecutionRequest;
import org.qubership.atp.mia.repo.ContextRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.SseEmitterService;
import org.qubership.atp.mia.service.execution.CompoundService;
import org.qubership.atp.mia.service.execution.MiaExecutionThreadPool;
import org.qubership.atp.mia.service.execution.ProcessService;
import org.qubership.atp.mia.service.monitoring.MetricsAggregateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping
public class SseController {
    private static final Logger log = LoggerFactory.getLogger(SseController.class);
    private final CompoundService compoundService;
    private final ProcessService processService;
    private final ContextRepository contextRepository;
    private final MetricsAggregateService metricsService;
    private final MiaContext miaContext;
    private final MiaExecutionThreadPool miaExecutionThreadPool;
    private final SseEmitterService sseEmitterService;

    @AuditAction(auditAction="Connect to SSE emitter with id '{{#sseId}}' for the '{{#projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'EXECUTE')")
    @GetMapping(value={"/sse/connect"}, produces={"text/event-stream"})
    public SseEmitter connect(@RequestParam UUID projectId, @RequestParam UUID sseId, @RequestHeader(value="Authorization") String token) throws IOException {
        SseEmitter emitter = this.sseEmitterService.getEmitter(sseId);
        if (emitter == null) {
            emitter = this.sseEmitterService.generateAndConfigureEmitter(sseId, token);
        }
        return emitter;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.mia.model.UserManagementEntities).COMPOUND.getName(),#projectId, 'EXECUTE')")
    @PostMapping(value={"/sse/compound"})
    @AuditAction(auditAction="Execute for compound \"{{#request.compound.name}}\" in Project - {{#projectId}}")
    public void executeCompound(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="env") String env, @RequestParam(value="sseId") UUID sseId, @RequestBody ExecutionRequest request) {
        this.executeCompoundOrProcess(projectId, env, sseId, request, this.compoundService::executeCompound);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.mia.model.UserManagementEntities).PROCESS.getName(),#projectId, 'EXECUTE')")
    @PostMapping(value={"/sse/process"})
    @AuditAction(auditAction="Execute process \"{{#request.process}}\" in Project - {{#projectId}}")
    public void executeProcess(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="env") String env, @RequestParam(value="sseId") UUID sseId, @RequestBody ExecutionRequest request) {
        this.executeCompoundOrProcess(projectId, env, sseId, request, this.processService::executeProcess);
    }

    private void executeCompoundOrProcess(UUID projectId, String env, UUID sseId, ExecutionRequest request, BiConsumer<ExecutionRequest, UUID> consumer) {
        Map mdcMap = MDC.getCopyOfContextMap();
        this.miaExecutionThreadPool.execute(DelegatingSecurityContextRunnable.create(() -> {
            try {
                MdcUtils.setContextMap((Map)mdcMap);
                log.debug("Set mia context with project ID '{}'", (Object)projectId);
                this.miaContext.setContext(request, projectId, env);
                if (request.getFlowData() != null && request.getFlowData().getParameters() != null) {
                    this.metricsService.requestContextSize(request.getFlowData().getParameters().size());
                }
                consumer.accept(request, sseId);
            }
            catch (MiaException e) {
                this.sseEmitterService.sendError(sseId, e);
            }
            catch (Exception e) {
                this.sseEmitterService.sendError(sseId, new MiaException(e));
            }
            finally {
                this.contextRepository.removeContext();
            }
        }, (SecurityContext)SecurityContextHolder.getContext()));
    }

    public SseController(CompoundService compoundService, ProcessService processService, ContextRepository contextRepository, MetricsAggregateService metricsService, MiaContext miaContext, MiaExecutionThreadPool miaExecutionThreadPool, SseEmitterService sseEmitterService) {
        this.compoundService = compoundService;
        this.processService = processService;
        this.contextRepository = contextRepository;
        this.metricsService = metricsService;
        this.miaContext = miaContext;
        this.miaExecutionThreadPool = miaExecutionThreadPool;
        this.sseEmitterService = sseEmitterService;
    }
}

