/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.CompareEntityResponseDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemResponseDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="mia-history-changes-controller", description="MIA History Change controller")
public interface MiaHistoryChangesControllerApi {
    @Operation(operationId="getAllHistory", summary="finds all changes history for defined object", tags={"mia-history-changes-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=HistoryItemResponseDto.class))}), @ApiResponse(responseCode="400", description="History for Entity type = '\" + itemType + \"' is not supported"), @ApiResponse(responseCode="404", description="Entity Id not found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/history/{projectId}/{itemType}/{id}"}, produces={"application/json"})
    public ResponseEntity<HistoryItemResponseDto> getAllHistory(@Parameter(name="projectId", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="itemType", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="itemType") String var2, @Parameter(name="id", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="id") UUID var3, @Parameter(name="offset", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="offset", required=false, defaultValue="0") Integer var4, @Parameter(name="limit", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false, defaultValue="10") Integer var5);

    @Operation(operationId="getEntitiesByVersion", summary="getEntitiesByVersion", tags={"mia-history-changes-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CompareEntityResponseDto.class)))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/entityversioning/{projectId}/{itemType}/{uuid}"}, produces={"application/json"})
    public ResponseEntity<List<CompareEntityResponseDto>> getEntitiesByVersion(@Parameter(name="projectId", description="projectId", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="itemType", description="itemType", required=true, in=ParameterIn.PATH) @PathVariable(value="itemType") String var2, @Parameter(name="uuid", description="uuid", required=true, in=ParameterIn.PATH) @PathVariable(value="uuid") UUID var3, @NotNull @Parameter(name="versions", description="versions", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="versions", required=true) List<String> var4);

    @Operation(operationId="restoreToRevision", summary="Restore the state of the provided entity to defined revision", tags={"mia-history-changes-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Entity Id not found"), @ApiResponse(responseCode="500", description="Revision was not restored")})
    @RequestMapping(method={RequestMethod.POST}, value={"/rest/history/restore/{projectId}/{itemType}/{id}/revision/{revisionId}"})
    public ResponseEntity<Void> restoreToRevision(@Parameter(name="projectId", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="projectId") UUID var1, @Parameter(name="itemType", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="itemType") String var2, @Parameter(name="id", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="id") UUID var3, @Parameter(name="revisionId", description="", required=true, in=ParameterIn.PATH) @PathVariable(value="revisionId") Integer var4);
}

