/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.AbstractCompareEntityDto;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;

public class DirectoryHistoryChangeDto
extends AbstractCompareEntityDto {
    private String name;
    private String parentDirectory;
    @Valid
    private List<String> childDirectories;
    @Valid
    private List<String> files;

    @Deprecated
    public DirectoryHistoryChangeDto() {
    }

    public DirectoryHistoryChangeDto(String name) {
        this.name = name;
    }

    public DirectoryHistoryChangeDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DirectoryHistoryChangeDto parentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
        return this;
    }

    @Schema(name="parentDirectory", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="parentDirectory")
    public String getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public DirectoryHistoryChangeDto childDirectories(List<String> childDirectories) {
        this.childDirectories = childDirectories;
        return this;
    }

    public DirectoryHistoryChangeDto addChildDirectoriesItem(String childDirectoriesItem) {
        if (this.childDirectories == null) {
            this.childDirectories = new ArrayList<String>();
        }
        this.childDirectories.add(childDirectoriesItem);
        return this;
    }

    @Schema(name="childDirectories", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="childDirectories")
    public List<String> getChildDirectories() {
        return this.childDirectories;
    }

    public void setChildDirectories(List<String> childDirectories) {
        this.childDirectories = childDirectories;
    }

    public DirectoryHistoryChangeDto files(List<String> files) {
        this.files = files;
        return this;
    }

    public DirectoryHistoryChangeDto addFilesItem(String filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        this.files.add(filesItem);
        return this;
    }

    @Schema(name="files", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="files")
    public List<String> getFiles() {
        return this.files;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    @Override
    public DirectoryHistoryChangeDto createdWhen(Long createdWhen) {
        super.setCreatedWhen(createdWhen);
        return this;
    }

    @Override
    public DirectoryHistoryChangeDto modifiedWhen(Long modifiedWhen) {
        super.setModifiedWhen(modifiedWhen);
        return this;
    }

    @Override
    public DirectoryHistoryChangeDto createdBy(String createdBy) {
        super.setCreatedBy(createdBy);
        return this;
    }

    @Override
    public DirectoryHistoryChangeDto modifiedBy(String modifiedBy) {
        super.setModifiedBy(modifiedBy);
        return this;
    }

    @Override
    public DirectoryHistoryChangeDto entityType(HistoryItemTypeDto entityType) {
        super.setEntityType(entityType);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryHistoryChangeDto directoryHistoryChange = (DirectoryHistoryChangeDto)o;
        return Objects.equals(this.name, directoryHistoryChange.name) && Objects.equals(this.parentDirectory, directoryHistoryChange.parentDirectory) && Objects.equals(this.childDirectories, directoryHistoryChange.childDirectories) && Objects.equals(this.files, directoryHistoryChange.files) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.parentDirectory, this.childDirectories, this.files, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DirectoryHistoryChangeDto {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentDirectory: ").append(this.toIndentedString(this.parentDirectory)).append("\n");
        sb.append("    childDirectories: ").append(this.toIndentedString(this.childDirectories)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

