/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.mia.controllers.api.dto.CommandDto;
import org.qubership.atp.mia.controllers.api.dto.InputDto;
import org.qubership.atp.mia.controllers.api.dto.PrerequisiteDto;
import org.qubership.atp.mia.controllers.api.dto.ValidationDto;

@JsonTypeName(value="Executable")
public class ExecutableDto {
    private UUID id;
    private String name;
    private String execType;
    private String pathToFile;
    @Valid
    private @Valid List<@Valid PrerequisiteDto> prerequisites;
    private CommandDto command;
    @Valid
    private @Valid List<@Valid ValidationDto> validations;
    @Valid
    private Map<String, String> globalVariables = new HashMap<String, String>();
    @Valid
    private @Valid List<@Valid InputDto> inputs;
    @Valid
    private @Valid List<@Valid ValidationDto> currentStatement;
    private String referToInput;
    @Valid
    private @Valid List<@Valid ExecutableDto> processList;

    public ExecutableDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Valid
    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public ExecutableDto name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExecutableDto execType(String execType) {
        this.execType = execType;
        return this;
    }

    @Schema(name="execType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="execType")
    public String getExecType() {
        return this.execType;
    }

    public void setExecType(String execType) {
        this.execType = execType;
    }

    public ExecutableDto pathToFile(String pathToFile) {
        this.pathToFile = pathToFile;
        return this;
    }

    @Schema(name="pathToFile", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="pathToFile")
    public String getPathToFile() {
        return this.pathToFile;
    }

    public void setPathToFile(String pathToFile) {
        this.pathToFile = pathToFile;
    }

    public ExecutableDto prerequisites(List<@Valid PrerequisiteDto> prerequisites) {
        this.prerequisites = prerequisites;
        return this;
    }

    public ExecutableDto addPrerequisitesItem(PrerequisiteDto prerequisitesItem) {
        if (this.prerequisites == null) {
            this.prerequisites = new ArrayList<PrerequisiteDto>();
        }
        this.prerequisites.add(prerequisitesItem);
        return this;
    }

    @Valid
    @Schema(name="prerequisites", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="prerequisites")
    public @Valid List<@Valid PrerequisiteDto> getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(List<@Valid PrerequisiteDto> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public ExecutableDto command(CommandDto command) {
        this.command = command;
        return this;
    }

    @Valid
    @Schema(name="command", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="command")
    public CommandDto getCommand() {
        return this.command;
    }

    public void setCommand(CommandDto command) {
        this.command = command;
    }

    public ExecutableDto validations(List<@Valid ValidationDto> validations) {
        this.validations = validations;
        return this;
    }

    public ExecutableDto addValidationsItem(ValidationDto validationsItem) {
        if (this.validations == null) {
            this.validations = new ArrayList<ValidationDto>();
        }
        this.validations.add(validationsItem);
        return this;
    }

    @Valid
    @Schema(name="validations", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="validations")
    public @Valid List<@Valid ValidationDto> getValidations() {
        return this.validations;
    }

    public void setValidations(List<@Valid ValidationDto> validations) {
        this.validations = validations;
    }

    public ExecutableDto globalVariables(Map<String, String> globalVariables) {
        this.globalVariables = globalVariables;
        return this;
    }

    public ExecutableDto putGlobalVariablesItem(String key, String globalVariablesItem) {
        if (this.globalVariables == null) {
            this.globalVariables = new HashMap<String, String>();
        }
        this.globalVariables.put(key, globalVariablesItem);
        return this;
    }

    @Schema(name="globalVariables", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="globalVariables")
    public Map<String, String> getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(Map<String, String> globalVariables) {
        this.globalVariables = globalVariables;
    }

    public ExecutableDto inputs(List<@Valid InputDto> inputs) {
        this.inputs = inputs;
        return this;
    }

    public ExecutableDto addInputsItem(InputDto inputsItem) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<InputDto>();
        }
        this.inputs.add(inputsItem);
        return this;
    }

    @Valid
    @Schema(name="inputs", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="inputs")
    public @Valid List<@Valid InputDto> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<@Valid InputDto> inputs) {
        this.inputs = inputs;
    }

    public ExecutableDto currentStatement(List<@Valid ValidationDto> currentStatement) {
        this.currentStatement = currentStatement;
        return this;
    }

    public ExecutableDto addCurrentStatementItem(ValidationDto currentStatementItem) {
        if (this.currentStatement == null) {
            this.currentStatement = new ArrayList<ValidationDto>();
        }
        this.currentStatement.add(currentStatementItem);
        return this;
    }

    @Valid
    @Schema(name="currentStatement", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="currentStatement")
    public @Valid List<@Valid ValidationDto> getCurrentStatement() {
        return this.currentStatement;
    }

    public void setCurrentStatement(List<@Valid ValidationDto> currentStatement) {
        this.currentStatement = currentStatement;
    }

    public ExecutableDto referToInput(String referToInput) {
        this.referToInput = referToInput;
        return this;
    }

    @Schema(name="referToInput", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="referToInput")
    public String getReferToInput() {
        return this.referToInput;
    }

    public void setReferToInput(String referToInput) {
        this.referToInput = referToInput;
    }

    public ExecutableDto processList(List<@Valid ExecutableDto> processList) {
        this.processList = processList;
        return this;
    }

    public ExecutableDto addProcessListItem(ExecutableDto processListItem) {
        if (this.processList == null) {
            this.processList = new ArrayList<ExecutableDto>();
        }
        this.processList.add(processListItem);
        return this;
    }

    @Valid
    @Schema(name="processList", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processList")
    public @Valid List<@Valid ExecutableDto> getProcessList() {
        return this.processList;
    }

    public void setProcessList(List<@Valid ExecutableDto> processList) {
        this.processList = processList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableDto executable = (ExecutableDto)o;
        return Objects.equals(this.id, executable.id) && Objects.equals(this.name, executable.name) && Objects.equals(this.execType, executable.execType) && Objects.equals(this.pathToFile, executable.pathToFile) && Objects.equals(this.prerequisites, executable.prerequisites) && Objects.equals(this.command, executable.command) && Objects.equals(this.validations, executable.validations) && Objects.equals(this.globalVariables, executable.globalVariables) && Objects.equals(this.inputs, executable.inputs) && Objects.equals(this.currentStatement, executable.currentStatement) && Objects.equals(this.referToInput, executable.referToInput) && Objects.equals(this.processList, executable.processList);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.execType, this.pathToFile, this.prerequisites, this.command, this.validations, this.globalVariables, this.inputs, this.currentStatement, this.referToInput, this.processList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecutableDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    execType: ").append(this.toIndentedString(this.execType)).append("\n");
        sb.append("    pathToFile: ").append(this.toIndentedString(this.pathToFile)).append("\n");
        sb.append("    prerequisites: ").append(this.toIndentedString(this.prerequisites)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    validations: ").append(this.toIndentedString(this.validations)).append("\n");
        sb.append("    globalVariables: ").append(this.toIndentedString(this.globalVariables)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    currentStatement: ").append(this.toIndentedString(this.currentStatement)).append("\n");
        sb.append("    referToInput: ").append(this.toIndentedString(this.referToInput)).append("\n");
        sb.append("    processList: ").append(this.toIndentedString(this.processList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

