/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.controllers.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.mia.controllers.api.dto.ProcessSettingsDto;

@JsonTypeName(value="Process")
public class ProcessDto {
    private UUID id;
    private String name;
    private ProcessSettingsDto processSettings;
    @Valid
    private List<UUID> inSections;
    @Valid
    private List<UUID> inCompounds;

    @Deprecated
    public ProcessDto() {
    }

    public ProcessDto(String name) {
        this.name = name;
    }

    public ProcessDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Valid
    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public ProcessDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessDto processSettings(ProcessSettingsDto processSettings) {
        this.processSettings = processSettings;
        return this;
    }

    @Valid
    @Schema(name="processSettings", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="processSettings")
    public ProcessSettingsDto getProcessSettings() {
        return this.processSettings;
    }

    public void setProcessSettings(ProcessSettingsDto processSettings) {
        this.processSettings = processSettings;
    }

    public ProcessDto inSections(List<UUID> inSections) {
        this.inSections = inSections;
        return this;
    }

    public ProcessDto addInSectionsItem(UUID inSectionsItem) {
        if (this.inSections == null) {
            this.inSections = new ArrayList<UUID>();
        }
        this.inSections.add(inSectionsItem);
        return this;
    }

    @Valid
    @Schema(name="inSections", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="inSections")
    public List<UUID> getInSections() {
        return this.inSections;
    }

    public void setInSections(List<UUID> inSections) {
        this.inSections = inSections;
    }

    public ProcessDto inCompounds(List<UUID> inCompounds) {
        this.inCompounds = inCompounds;
        return this;
    }

    public ProcessDto addInCompoundsItem(UUID inCompoundsItem) {
        if (this.inCompounds == null) {
            this.inCompounds = new ArrayList<UUID>();
        }
        this.inCompounds.add(inCompoundsItem);
        return this;
    }

    @Valid
    @Schema(name="inCompounds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="inCompounds")
    public List<UUID> getInCompounds() {
        return this.inCompounds;
    }

    public void setInCompounds(List<UUID> inCompounds) {
        this.inCompounds = inCompounds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessDto process = (ProcessDto)o;
        return Objects.equals(this.id, process.id) && Objects.equals(this.name, process.name) && Objects.equals(this.processSettings, process.processSettings) && Objects.equals(this.inSections, process.inSections) && Objects.equals(this.inCompounds, process.inCompounds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.processSettings, this.inSections, this.inCompounds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    processSettings: ").append(this.toIndentedString(this.processSettings)).append("\n");
        sb.append("    inSections: ").append(this.toIndentedString(this.inSections)).append("\n");
        sb.append("    inCompounds: ").append(this.toIndentedString(this.inCompounds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

