/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qubership.atp.mia.ei.service.AtpImportStrategy;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.model.file.ProjectFile;

public class ExportImportUtils {
    public static UUID getFolderId(ProjectDirectory directory) {
        return Objects.isNull(directory) ? null : Optional.ofNullable(directory.getSourceId()).orElse(directory.getId());
    }

    public static String generateCopyEntryName(String name) {
        if (Objects.isNull(name) || name.isEmpty()) {
            name = "unknown_entry";
        }
        return name + "_ImportConflict_" + AtpImportStrategy.IMPORT_TIMESTAMP.get();
    }

    public static Map<UUID, ProjectDirectory> createMapIdToExistingDirectory(ProjectConfiguration projectConfiguration) {
        return projectConfiguration.getDirectories().stream().flatMap(pd -> Stream.of(new AbstractMap.SimpleEntry<UUID, ProjectDirectory>(pd.getSourceId(), (ProjectDirectory)pd), new AbstractMap.SimpleEntry<UUID, ProjectDirectory>(pd.getId(), (ProjectDirectory)pd))).filter(entry -> Objects.nonNull(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, duplicate) -> duplicate));
    }

    public static Map<UUID, Map<String, ProjectDirectory>> createMapParentIdToDirectoryNames(ProjectConfiguration projectConfiguration) {
        HashMap<UUID, Map<String, ProjectDirectory>> result = new HashMap<UUID, Map<String, ProjectDirectory>>();
        for (ProjectDirectory directory : projectConfiguration.getDirectories()) {
            result.computeIfAbsent(ExportImportUtils.getFolderId(directory.getParentDirectory()), key -> new HashMap()).put(directory.getName(), directory);
        }
        return result;
    }

    public static Map<UUID, Map<String, ProjectFile>> createMapParentIdToFileNames(ProjectConfiguration projectConfiguration) {
        HashMap<UUID, Map<String, ProjectFile>> result = new HashMap<UUID, Map<String, ProjectFile>>();
        for (ProjectFile file : projectConfiguration.getFiles()) {
            result.computeIfAbsent(ExportImportUtils.getFolderId(file.getDirectory()), key -> new HashMap()).put(file.getName(), file);
        }
        return result;
    }

    public static Map<UUID, ProjectFile> createMapIdToExistingFile(ProjectConfiguration projectConfiguration) {
        return projectConfiguration.getFiles().stream().flatMap(pd -> Stream.of(new AbstractMap.SimpleEntry<UUID, ProjectFile>(pd.getSourceId(), (ProjectFile)pd), new AbstractMap.SimpleEntry<UUID, ProjectFile>(pd.getId(), (ProjectFile)pd))).filter(entry -> Objects.nonNull(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, duplicate) -> duplicate));
    }

    public static <K, V> Map<V, K> reverseMap(Map<K, V> originalMap) {
        HashMap<V, K> reversedMap = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : originalMap.entrySet()) {
            reversedMap.put(entry.getValue(), entry.getKey());
        }
        return reversedMap;
    }
}

