/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.mia.ei.service.ExportStrategy;
import org.qubership.atp.mia.exceptions.ei.MiaExportTypeNotSupportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportStrategiesRegistry {
    private static final Logger log = LoggerFactory.getLogger(ExportStrategiesRegistry.class);
    private final List<ExportStrategy> exportStrategies;

    public ExportStrategy getExportStrategy(@NotNull ExportFormat format) throws MiaExportTypeNotSupportException {
        return this.exportStrategies.stream().filter(exportStrategy -> format.equals((Object)exportStrategy.getFormat())).findFirst().orElseThrow(() -> new MiaExportTypeNotSupportException(format.name()));
    }

    public ExportStrategiesRegistry(List<ExportStrategy> exportStrategies) {
        this.exportStrategies = exportStrategies;
    }
}

