/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.mia.ei.component.ImportLoader;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportCommandPrefix;
import org.qubership.atp.mia.model.ei.ExportImportCommonConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportLoaderCommonConfiguration
extends ImportLoader<ExportImportEntities, CommonConfiguration, ExportImportCommonConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ImportLoaderCommonConfiguration.class);

    public ImportLoaderCommonConfiguration(@Autowired ObjectLoaderFromDiskService objectLoaderFromDiskService) {
        super(objectLoaderFromDiskService);
    }

    @Override
    public Class<ExportImportCommonConfiguration> getClazz() {
        return ExportImportCommonConfiguration.class;
    }

    @Override
    public ExportImportEntities getEntityType() {
        return ExportImportEntities.MIA_COMMON_CONFIGURATION;
    }

    @Override
    public CommonConfiguration toEntity(ProjectConfiguration projectConfig, ExportImportCommonConfiguration dto) {
        CommonConfiguration commonConfiguration = CommonConfiguration.builder().projectId(projectConfig.getProjectId()).defaultSystem(dto.getDefaultSystem()).useVariablesInsideVariable(dto.isUseVariablesInsideVariable()).variableFormat(dto.getVariableFormat()).saveFilesToWorkingDir(dto.isSaveFilesToWorkingDir()).saveSqlTablesToFile(dto.isSaveSqlTablesToFile()).commonVariables(dto.getCommonVariables()).nextBillDateSql(dto.getNextBillDateSql()).resetCacheSql(dto.getResetCacheSql()).ethalonFilesPath(dto.getEthalonFilesPath()).externalEnvironmentPrefix(dto.getExternalEnvironmentPrefix()).commandShellSeparator(dto.getCommandShellSeparator()).genevaDateMask(dto.getGenevaDateMask()).sshRsaFilePath(dto.getSshRsaFilePath()).linesAmount(dto.getLinesAmount()).projectConfiguration(projectConfig).build();
        commonConfiguration.setCommandShellPrefixes(dto.getCommandShellPrefixes().stream().map(eip -> ExportImportCommandPrefix.toEntity(projectConfig, eip, commonConfiguration)).collect(Collectors.toList()));
        return commonConfiguration;
    }

    @Override
    public List<UUID> validate(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) throws MiaException {
        return Collections.emptyList();
    }

    @Override
    public void importEntity(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) {
        List configurations = this.loadConfiguration(importData, path);
        if (!configurations.isEmpty()) {
            ExportImportCommonConfiguration configuration = (ExportImportCommonConfiguration)configurations.get(0);
            projectConfiguration.setCommonConfiguration(this.toEntity(projectConfiguration, configuration));
        }
    }
}

