/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.mia.ei.component.ExportImportUtils;
import org.qubership.atp.mia.ei.component.ImportLoader;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.exceptions.ei.MiaImportParentDirectoryNotFound;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportDirectory;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.repo.configuration.DirectoryConfigurationRepository;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ImportLoaderDirectory
extends ImportLoader<ExportImportEntities, ProjectDirectory, ExportImportDirectory> {
    private static final Logger log = LoggerFactory.getLogger(ImportLoaderDirectory.class);
    private final GridFsService gridFsService;
    private final DirectoryConfigurationRepository directoryConfigurationRepository;
    private final ProjectConfigurationService projectConfigurationService;

    public ImportLoaderDirectory(@Autowired ObjectLoaderFromDiskService objectLoaderFromDiskService, GridFsService gridFsService, DirectoryConfigurationRepository directoryConfigurationRepository, ProjectConfigurationService projectConfigurationService) {
        super(objectLoaderFromDiskService);
        this.gridFsService = gridFsService;
        this.directoryConfigurationRepository = directoryConfigurationRepository;
        this.projectConfigurationService = projectConfigurationService;
    }

    @Override
    public Class<ExportImportDirectory> getClazz() {
        return ExportImportDirectory.class;
    }

    @Override
    public ExportImportEntities getEntityType() {
        return ExportImportEntities.MIA_DIRECTORY;
    }

    @Override
    public ProjectDirectory toEntity(ProjectConfiguration projectConfiguration, ExportImportDirectory exportImportDirectory) {
        DateAuditorEntity parentDirectory = Objects.isNull(exportImportDirectory.getParentDirectory()) ? null : ((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)new ProjectDirectory().toBuilder()).id(exportImportDirectory.getParentDirectory())).build();
        return ((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)ProjectDirectory.builder().id(exportImportDirectory.getId())).sourceId(exportImportDirectory.getSourceId())).name(exportImportDirectory.getName())).parentDirectory((ProjectDirectory)parentDirectory)).projectConfiguration(projectConfiguration)).build();
    }

    @Override
    public List<UUID> validate(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) throws MiaException {
        Map<UUID, ProjectDirectory> existingIdToDirectory = ExportImportUtils.createMapIdToExistingDirectory(projectConfiguration);
        return this.loadImportDirectories(projectConfiguration, importData, path, existingIdToDirectory).stream().map(ProjectDirectory::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void importEntity(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) {
        Map<UUID, ProjectDirectory> existingIdToDirectory = ExportImportUtils.createMapIdToExistingDirectory(projectConfiguration);
        List<ProjectDirectory> directories = this.loadImportDirectories(projectConfiguration, importData, path, existingIdToDirectory);
        this.mergeImportDirectoriesWithExisting(projectConfiguration, directories, existingIdToDirectory);
    }

    @NotNull
    private List<ProjectDirectory> loadImportDirectories(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path, Map<UUID, ProjectDirectory> existingIdToDirectory) {
        ArrayList<ProjectDirectory> directories = new ArrayList<ProjectDirectory>();
        HashMap<UUID, ProjectDirectory> idToDirectory = new HashMap<UUID, ProjectDirectory>();
        List eiDirectories = this.loadConfiguration(importData, path);
        for (ExportImportDirectory eiDirectory : eiDirectories) {
            ProjectDirectory directory = this.toEntity(projectConfiguration, eiDirectory);
            idToDirectory.put(directory.getSourceId(), directory);
            idToDirectory.put(directory.getId(), directory);
            directories.add(directory);
        }
        Map reverseReplacementMap = ExportImportUtils.reverseMap(importData.getReplacementMap());
        for (ProjectDirectory directory : directories) {
            if (!Objects.nonNull(directory.getParentDirectory())) continue;
            UUID parentId = directory.getParentDirectory().getId();
            ProjectDirectory parent = existingIdToDirectory.getOrDefault(parentId, existingIdToDirectory.get(reverseReplacementMap.get(parentId)));
            if (Objects.isNull(parent)) {
                parent = (ProjectDirectory)idToDirectory.get(parentId);
            }
            if (Objects.nonNull(parent)) {
                directory.setParentDirectory(parent);
                continue;
            }
            throw new MiaImportParentDirectoryNotFound("directory", directory.getName());
        }
        return directories;
    }

    private void mergeImportDirectoriesWithExisting(ProjectConfiguration projectConfiguration, List<ProjectDirectory> importDirectories, Map<UUID, ProjectDirectory> existingIdToDirectory) {
        Map<UUID, Map<String, ProjectDirectory>> folderIdWithEntryNames = ExportImportUtils.createMapParentIdToDirectoryNames(projectConfiguration);
        for (ProjectDirectory importDirectory : importDirectories) {
            this.mergeDirectory(projectConfiguration, importDirectory, existingIdToDirectory, folderIdWithEntryNames);
        }
    }

    private void mergeDirectory(ProjectConfiguration projectConfiguration, ProjectDirectory importDirectory, Map<UUID, ProjectDirectory> existingIdToDirectory, Map<UUID, Map<String, ProjectDirectory>> folderIdWithEntryNames) {
        ProjectDirectory conflictingDirectory = existingIdToDirectory.getOrDefault(importDirectory.getId(), existingIdToDirectory.get(importDirectory.getSourceId()));
        if (Objects.nonNull(conflictingDirectory)) {
            conflictingDirectory.setName(importDirectory.getName());
            conflictingDirectory.setSourceId(importDirectory.getSourceId());
            Optional.ofNullable(conflictingDirectory.getParentDirectory()).ifPresent(parent -> parent.getDirectories().remove(conflictingDirectory));
            Optional.ofNullable(importDirectory.getParentDirectory()).ifPresent(directory -> directory.getDirectories().add(conflictingDirectory));
            conflictingDirectory.setParentDirectory(importDirectory.getParentDirectory());
        } else {
            this.validateDuplicateDirectory(projectConfiguration, importDirectory, folderIdWithEntryNames);
            Optional.ofNullable(importDirectory.getParentDirectory()).map(ProjectDirectory::getDirectories).ifPresent(directories -> directories.add(importDirectory));
            existingIdToDirectory.put(importDirectory.getId(), importDirectory);
            projectConfiguration.getDirectories().add(importDirectory);
        }
    }

    private void validateDuplicateDirectory(ProjectConfiguration projectConfiguration, ProjectDirectory importDirectory, Map<UUID, Map<String, ProjectDirectory>> folderIdWithEntryNames) {
        ProjectDirectory duplicateDirectory;
        boolean duplicateDirectoryInFolder;
        UUID parentId = ExportImportUtils.getFolderId(importDirectory.getParentDirectory());
        Map<String, ProjectDirectory> namesInCurrentFolder = folderIdWithEntryNames.get(parentId);
        boolean folderExist = Objects.nonNull(namesInCurrentFolder);
        if (folderExist && (duplicateDirectoryInFolder = Objects.nonNull(duplicateDirectory = namesInCurrentFolder.get(importDirectory.getName())))) {
            duplicateDirectory.setName(ExportImportUtils.generateCopyEntryName(duplicateDirectory.getName()));
            this.recursiveRenameFiles(duplicateDirectory);
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.directoryConfigurationRepository.save(duplicateDirectory);
                return projectConfiguration;
            }, true);
        }
    }

    private void recursiveRenameFiles(ProjectDirectory directory) {
        directory.getFiles().forEach(this.gridFsService::rename);
        directory.getDirectories().forEach(this::recursiveRenameFiles);
    }
}

