/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.ei.component;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.mia.ei.component.ImportLoader;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.model.configuration.PotHeaderConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportEntities;
import org.qubership.atp.mia.model.ei.ExportImportPotHeaderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportLoaderPotHeaderConfiguration
extends ImportLoader<ExportImportEntities, PotHeaderConfiguration, ExportImportPotHeaderConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ImportLoaderPotHeaderConfiguration.class);

    public ImportLoaderPotHeaderConfiguration(@Autowired ObjectLoaderFromDiskService objectLoaderFromDiskService) {
        super(objectLoaderFromDiskService);
    }

    @Override
    public Class<ExportImportPotHeaderConfiguration> getClazz() {
        return ExportImportPotHeaderConfiguration.class;
    }

    @Override
    public ExportImportEntities getEntityType() {
        return ExportImportEntities.MIA_POT_HEADER_CONFIGURATION;
    }

    @Override
    public PotHeaderConfiguration toEntity(ProjectConfiguration projectConfig, ExportImportPotHeaderConfiguration dto) {
        return PotHeaderConfiguration.builder().projectId(projectConfig.getProjectId()).headers(dto.getHeaders()).projectConfiguration(projectConfig).build();
    }

    @Override
    public List<UUID> validate(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) throws MiaException {
        return Collections.emptyList();
    }

    @Override
    public void importEntity(ProjectConfiguration projectConfiguration, ExportImportData importData, Path path) {
        List configurations = this.loadConfiguration(importData, path);
        if (!configurations.isEmpty()) {
            ExportImportPotHeaderConfiguration configuration = (ExportImportPotHeaderConfiguration)configurations.get(0);
            projectConfiguration.setPotHeaderConfiguration(this.toEntity(projectConfiguration, configuration));
        }
    }
}

