/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.kafka.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.serialization.UUIDDeserializer;
import org.apache.kafka.common.serialization.UUIDSerializer;
import org.qubership.atp.mia.kafka.model.KafkaRequestImport;
import org.qubership.atp.mia.kafka.model.notification.EnvironmentUpdateEvent;
import org.qubership.atp.mia.kafka.model.notification.ProjectEvent;
import org.qubership.atp.mia.kafka.producers.MiaExecutionFinishProducer;
import org.qubership.atp.mia.kafka.service.ItfImportFinishNotificationService;
import org.qubership.atp.mia.model.impl.ExecutionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.TopicBuilder;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.AlwaysRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@ConditionalOnProperty(value={"kafka.enable"}, havingValue="true")
public class KafkaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KafkaConfiguration.class);
    public static final String CATALOG_PROJECT_EVENT_CONTAINER_FACTORY = "catalogProjectEventContainerFactory";
    public static final String ITF_IMPORT_CONTAINER_FACTORY = "itfImportContainerFactory";
    public static final String MIA_EXECUTION_FINISH_CONTAINER_FACTORY_BEAN_NAME = "miaExecutionFinishKafkaContainerFactory";
    public static final String ENVIRONMENT_UPDATE_EVENT_CONTAINER_FACTORY = "environmentUpdateEventContainerFactory";
    @Value(value="${kafka.itf.import.end.partitions:1}")
    public int kafkaExecutionEndPartitions;
    @Value(value="${kafka.itf.import.end.replicas:3}")
    public int kafkaExecutionEndReplicas;
    @Value(value="${kafka.mia.execution.finish.partitions:1}")
    public int kafkaMiaExecutionFinishPartitions;
    @Value(value="${kafka.mia.execution.finish.replicas:3}")
    public int kafkaMiaExecutionFinishReplicas;
    @Value(value="${kafka.mia.execution.finish.topic}")
    public String kafkaMiaExecutionFinishTopic;
    @Value(value="${kafka.retry.backoff.period}")
    private String backOffPeriod;
    @Value(value="${kafka.itf.import.end.topic}")
    private String kafkaItfImportFinishTopic;
    @Value(value="${kafka.server}")
    private String kafkaServer;

    @Bean
    public Map<String, Object> consumerConfigJsonValue() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.kafkaServer);
        props.put("key.deserializer", UUIDDeserializer.class);
        props.put("value.deserializer", JsonDeserializer.class);
        props.put("spring.json.trusted.packages", "*");
        props.put("enable.auto.commit", false);
        return props;
    }

    @Bean(value={"catalogProjectEventContainerFactory"})
    public ConcurrentKafkaListenerContainerFactory<UUID, ProjectEvent> containerFactoryCatalogProjectEvent() {
        ConcurrentKafkaListenerContainerFactory containerFactory = new ConcurrentKafkaListenerContainerFactory();
        containerFactory.setConsumerFactory(this.catalogConsumerFactory());
        return containerFactory;
    }

    @Bean(value={"itfImportContainerFactory"})
    public ConcurrentKafkaListenerContainerFactory<UUID, String> containerFactoryItfImport() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.itfImportConsumerFactory());
        factory.getContainerProperties().setAckMode(ContainerProperties.AckMode.RECORD);
        factory.setRetryTemplate(this.retryTemplate());
        factory.setStatefulRetry(true);
        return factory;
    }

    @Bean(value={"miaExecutionFinishKafkaContainerFactory"})
    public ConcurrentKafkaListenerContainerFactory<UUID, ExecutionResponse> containerFactoryMiaExecutionFinish() {
        log.debug("Start MIA execution finish kafka container factory: {}", (Object)MIA_EXECUTION_FINISH_CONTAINER_FACTORY_BEAN_NAME);
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.miaExecutionFinishConsumerFactory());
        return factory;
    }

    @Bean(value={"environmentUpdateEventContainerFactory"})
    public ConcurrentKafkaListenerContainerFactory<UUID, EnvironmentUpdateEvent> containerFactoryEnvironmentUpdateEvent() {
        ConcurrentKafkaListenerContainerFactory containerFactory = new ConcurrentKafkaListenerContainerFactory();
        containerFactory.setConsumerFactory(this.environmentUpdatesConsumerFactory());
        return containerFactory;
    }

    @Bean
    public ItfImportFinishNotificationService endItfImportNotificationService() {
        return new ItfImportFinishNotificationService(this.kafkaItfImportFinishTopic, this.kafkaTemplate());
    }

    @Bean
    public ConsumerFactory itfImportConsumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigJsonValue(), (Deserializer)new UUIDDeserializer(), (Deserializer)new JsonDeserializer(KafkaRequestImport.class, false));
    }

    @Bean
    public KafkaTemplate<UUID, String> kafkaTemplate() {
        log.info("Create KafkaTemplate bean");
        return new KafkaTemplate(this.producerFactory());
    }

    @Bean
    public MiaExecutionFinishProducer miaExecutionFinishProducer() {
        return new MiaExecutionFinishProducer(this.producerConfig(JsonSerializer.class));
    }

    @Bean
    public ProducerFactory<UUID, String> producerFactory() {
        log.info("ProducerFactory");
        return new DefaultKafkaProducerFactory(this.producerConfig(StringSerializer.class));
    }

    @Bean
    public RetryTemplate retryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)new AlwaysRetryPolicy());
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        fixedBackOffPolicy.setBackOffPeriod(Long.parseLong(this.backOffPeriod));
        retryTemplate.setBackOffPolicy((BackOffPolicy)fixedBackOffPolicy);
        return retryTemplate;
    }

    @Bean
    public NewTopic topicItfImportFinishEnd() {
        return TopicBuilder.name((String)this.kafkaItfImportFinishTopic).partitions(this.kafkaExecutionEndPartitions).replicas(this.kafkaExecutionEndReplicas).build();
    }

    @Bean
    public NewTopic topicMiaExecutionFinish() {
        return TopicBuilder.name((String)this.kafkaMiaExecutionFinishTopic).partitions(this.kafkaMiaExecutionFinishPartitions).replicas(this.kafkaMiaExecutionFinishReplicas).build();
    }

    private ConsumerFactory<UUID, ProjectEvent> catalogConsumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigJsonValue(), (Deserializer)new UUIDDeserializer(), (Deserializer)new JsonDeserializer(ProjectEvent.class, false));
    }

    private ConsumerFactory<UUID, ExecutionResponse> miaExecutionFinishConsumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigJsonValue(), (Deserializer)new UUIDDeserializer(), (Deserializer)new JsonDeserializer(ExecutionResponse.class, false));
    }

    private ConsumerFactory<UUID, EnvironmentUpdateEvent> environmentUpdatesConsumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigJsonValue(), (Deserializer)new UUIDDeserializer(), (Deserializer)new JsonDeserializer(EnvironmentUpdateEvent.class, false));
    }

    private Map<String, Object> producerConfig(Class<?> clazz) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.kafkaServer);
        props.put("key.serializer", UUIDSerializer.class);
        props.put("value.serializer", clazz);
        return props;
    }
}

