/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.kafka.producers;

import java.util.Map;
import java.util.UUID;
import org.qubership.atp.mia.model.impl.ExecutionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

public class MiaExecutionFinishProducer {
    private static final Logger log = LoggerFactory.getLogger(MiaExecutionFinishProducer.class);
    private final KafkaTemplate<UUID, ExecutionResponse> miaExecutionFinishKafkaTemplate;
    private final boolean mock;
    @Value(value="${kafka.mia.execution.finish.topic}")
    public String miaExecutionFinishTopic;

    public MiaExecutionFinishProducer(Map<String, Object> kafkaProducerConfigJson) {
        boolean bl = this.mock = kafkaProducerConfigJson == null;
        if (!this.mock) {
            DefaultKafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory(kafkaProducerConfigJson);
            this.miaExecutionFinishKafkaTemplate = new KafkaTemplate((ProducerFactory)producerFactory);
        } else {
            this.miaExecutionFinishKafkaTemplate = null;
        }
    }

    public boolean executionFinishEventSend(ExecutionResponse executionFinishEvent) {
        if (!this.mock && this.miaExecutionFinishKafkaTemplate != null) {
            log.debug("Send execution finish event for sseId = {}", (Object)executionFinishEvent.getSseId());
            this.miaExecutionFinishKafkaTemplate.send(this.miaExecutionFinishTopic, (Object)executionFinishEvent.getSseId(), (Object)executionFinishEvent);
            return true;
        }
        return false;
    }

    public boolean isMock() {
        return this.mock;
    }
}

