/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model;

import java.util.concurrent.TimeUnit;

public enum CacheKeys {
    AUTH_PROJECTS_KEY("auth_projects", 5, TimeUnit.MINUTES, CacheGroups.PROJECTS, true),
    PROJECTNAME_KEY("ATP_MIA_PROJECT_NAME_OS", 24, TimeUnit.DAYS, CacheGroups.PROJECTS, true),
    CONFIGURATION_KEY("ATP_MIA_CONFIGURATION_OS", 5, TimeUnit.MINUTES, CacheGroups.PROJECTS, true),
    ENVIRONMENTS_KEY("ATP_MIA_ENVIRONMENTS_OS", 1, TimeUnit.HOURS, CacheGroups.ENVIRONMENT, true),
    ENVIRONMENTS_BY_NAME_KEY("ATP_MIA_ENVIRONMENTS_BY_NAME_OS", 1, TimeUnit.HOURS, CacheGroups.ENVIRONMENT, true),
    ENVIRONMENTSFULL_KEY("ATP_MIA_ENVIRONMENTSFULL_OS", 10, TimeUnit.MINUTES, CacheGroups.ENVIRONMENT, true),
    SYSTEM_NAMES("ATP_MIA_SYSTEM_NAMES_OS", 20, TimeUnit.MINUTES, CacheGroups.SYSTEMS, false),
    MIA_PROJECTS_KEY("ATP_MIA_PROJECTS_OS", 2, TimeUnit.HOURS, CacheGroups.ENVIRONMENT, false),
    ATP_MACROS_KEY("ATP_MIA_MACROS_OS", 5, TimeUnit.MINUTES, CacheGroups.MACROS, true);

    private final String key;
    private final int timeToLive;
    private final TimeUnit timeUnit;
    private final CacheGroups cacheGroup;
    private final boolean isKeyContainProjectId;

    private CacheKeys(String key, int timeToLive, TimeUnit timeUnit, CacheGroups cacheGroup, boolean isCacheContainsProjectId) {
        this.key = key;
        this.timeToLive = timeToLive;
        this.timeUnit = timeUnit;
        this.cacheGroup = cacheGroup;
        this.isKeyContainProjectId = isCacheContainsProjectId;
    }

    public int getTtlInSeconds() {
        switch (this.timeUnit) {
            case SECONDS: {
                return this.timeToLive;
            }
            case MINUTES: {
                return 60 * this.timeToLive;
            }
            case HOURS: {
                return 3600 * this.timeToLive;
            }
            case DAYS: {
                return 86400 * this.timeToLive;
            }
        }
        return 0;
    }

    public String getKey() {
        return this.key;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public CacheGroups getCacheGroup() {
        return this.cacheGroup;
    }

    public boolean isKeyContainProjectId() {
        return this.isKeyContainProjectId;
    }

    public static enum CacheGroups {
        PROJECTS,
        ENVIRONMENT,
        SYSTEMS,
        MACROS,
        CONFIGURATION;

    }

    public static class Constants {
        public static final String AUTH_PROJECTS_KEY = "auth_projects";
        public static final String PROJECTNAME_KEY = "ATP_MIA_PROJECT_NAME_OS";
        public static final String CONFIGURATION_KEY = "ATP_MIA_CONFIGURATION_OS";
        public static final String ENVIRONMENTS_KEY = "ATP_MIA_ENVIRONMENTS_OS";
        public static final String ENVIRONMENTS_BY_NAME_KEY = "ATP_MIA_ENVIRONMENTS_BY_NAME_OS";
        public static final String ENVIRONMENTSFULL_KEY = "ATP_MIA_ENVIRONMENTSFULL_OS";
        public static final String SYSTEM_NAMES = "ATP_MIA_SYSTEM_NAMES_OS";
        public static final String MIA_PROJECTS_KEY = "ATP_MIA_PROJECTS_OS";
        public static final String ATP_MACROS_KEY = "ATP_MIA_MACROS_OS";
    }
}

