/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.configuration;

import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.Value;
import org.qubership.atp.mia.model.configuration.CommandPrefixId;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;

@Entity
@Table(name="project_command_prefix")
@TypeDef(name="jsonb", typeClass=JsonBinaryType.class)
@IdClass(value=CommandPrefixId.class)
@Value
public class CommandPrefix
implements Serializable {
    private static final long serialVersionUID = 2325603243441977662L;
    @Id
    private UUID projectId;
    @Id
    private String system;
    @Column(name="prefixes", columnDefinition="jsonb")
    @Type(type="jsonb")
    private LinkedHashMap<String, String> prefixes;
    @ManyToOne(targetEntity=CommonConfiguration.class, optional=false)
    @JoinColumn(name="project_id", referencedColumnName="project_id", insertable=false, updatable=false)
    @DiffIgnore
    private CommonConfiguration commonConfiguration;

    public static CommandPrefixBuilder builder() {
        return new CommandPrefixBuilder();
    }

    public CommandPrefixBuilder toBuilder() {
        return new CommandPrefixBuilder().projectId(this.projectId).system(this.system).prefixes(this.prefixes).commonConfiguration(this.commonConfiguration);
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public String getSystem() {
        return this.system;
    }

    public LinkedHashMap<String, String> getPrefixes() {
        return this.prefixes;
    }

    public CommonConfiguration getCommonConfiguration() {
        return this.commonConfiguration;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setPrefixes(LinkedHashMap<String, String> prefixes) {
        this.prefixes = prefixes;
    }

    public void setCommonConfiguration(CommonConfiguration commonConfiguration) {
        this.commonConfiguration = commonConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandPrefix)) {
            return false;
        }
        CommandPrefix other = (CommandPrefix)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$system = this.getSystem();
        String other$system = other.getSystem();
        if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
            return false;
        }
        LinkedHashMap<String, String> this$prefixes = this.getPrefixes();
        LinkedHashMap<String, String> other$prefixes = other.getPrefixes();
        return !(this$prefixes == null ? other$prefixes != null : !((Object)this$prefixes).equals(other$prefixes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandPrefix;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : $system.hashCode());
        LinkedHashMap<String, String> $prefixes = this.getPrefixes();
        result = result * 59 + ($prefixes == null ? 43 : ((Object)$prefixes).hashCode());
        return result;
    }

    public String toString() {
        return "CommandPrefix(projectId=" + this.getProjectId() + ", system=" + this.getSystem() + ", prefixes=" + this.getPrefixes() + ")";
    }

    public CommandPrefix() {
    }

    public CommandPrefix(UUID projectId, String system, LinkedHashMap<String, String> prefixes, CommonConfiguration commonConfiguration) {
        this.projectId = projectId;
        this.system = system;
        this.prefixes = prefixes;
        this.commonConfiguration = commonConfiguration;
    }

    public static class CommandPrefixBuilder {
        private UUID projectId;
        private String system;
        private LinkedHashMap<String, String> prefixes;
        private CommonConfiguration commonConfiguration;

        CommandPrefixBuilder() {
        }

        public CommandPrefixBuilder projectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        public CommandPrefixBuilder system(String system) {
            this.system = system;
            return this;
        }

        public CommandPrefixBuilder prefixes(LinkedHashMap<String, String> prefixes) {
            this.prefixes = prefixes;
            return this;
        }

        public CommandPrefixBuilder commonConfiguration(CommonConfiguration commonConfiguration) {
            this.commonConfiguration = commonConfiguration;
            return this;
        }

        public CommandPrefix build() {
            return new CommandPrefix(this.projectId, this.system, this.prefixes, this.commonConfiguration);
        }

        public String toString() {
            return "CommandPrefix.CommandPrefixBuilder(projectId=" + this.projectId + ", system=" + this.system + ", prefixes=" + this.prefixes + ", commonConfiguration=" + this.commonConfiguration + ")";
        }
    }
}

