/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.configuration;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.vladmihalcea.hibernate.type.json.JsonType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.converters.ListConverter;
import org.qubership.atp.mia.model.impl.executable.ProcessSettings;

@Entity
@Table(name="project_processes_configuration")
@TypeDef(name="json", typeClass=JsonType.class)
public class ProcessConfiguration
extends DateAuditorEntity {
    private static final long serialVersionUID = -8870451957638368825L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    @DiffInclude
    private UUID id;
    @Column(name="source_id")
    private UUID sourceId;
    @Column(name="process_name")
    @DiffInclude
    private String name;
    @Column(name="file_name")
    @DiffInclude
    private String pathToFile;
    @Column(name="process_settings", columnDefinition="json")
    @Type(type="json")
    @DiffInclude
    private ProcessSettings processSettings;
    @ManyToMany(mappedBy="processes", targetEntity=CompoundConfiguration.class, cascade={CascadeType.MERGE})
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffIgnore
    private List<CompoundConfiguration> inCompounds;
    @Column(name="in_compounds", columnDefinition="TEXT")
    @Convert(converter=ListConverter.class)
    @DiffInclude
    private List<String> compounds;
    @ManyToMany(mappedBy="processes", targetEntity=SectionConfiguration.class, cascade={CascadeType.MERGE})
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffIgnore
    private List<SectionConfiguration> inSections;
    @Column(name="in_sections", columnDefinition="TEXT")
    @DiffInclude
    @Convert(converter=ListConverter.class)
    private List<String> sections;
    @ManyToOne(targetEntity=ProjectConfiguration.class)
    @JoinColumn(name="project_id", nullable=false)
    @DiffIgnore
    private ProjectConfiguration projectConfiguration;

    @JsonSetter
    public void setInCompounds(List<CompoundConfiguration> compounds) {
        this.inCompounds = compounds;
        this.compounds = compounds != null ? (List)compounds.stream().map(CompoundConfiguration::getName).collect(Collectors.toCollection(LinkedList::new)) : null;
    }

    @JsonSetter
    public void setInSections(List<SectionConfiguration> sections) {
        this.inSections = sections;
        this.sections = sections != null ? (List)sections.stream().map(SectionConfiguration::getName).collect(Collectors.toCollection(LinkedList::new)) : null;
    }

    private static List<CompoundConfiguration> $default$inCompounds() {
        return new ArrayList<CompoundConfiguration>();
    }

    private static List<String> $default$compounds() {
        return new ArrayList<String>();
    }

    private static List<SectionConfiguration> $default$inSections() {
        return new ArrayList<SectionConfiguration>();
    }

    private static List<String> $default$sections() {
        return new ArrayList<String>();
    }

    protected ProcessConfiguration(ProcessConfigurationBuilder<?, ?> b) {
        super(b);
        this.id = ((ProcessConfigurationBuilder)b).id;
        this.sourceId = ((ProcessConfigurationBuilder)b).sourceId;
        this.name = ((ProcessConfigurationBuilder)b).name;
        this.pathToFile = ((ProcessConfigurationBuilder)b).pathToFile;
        this.processSettings = ((ProcessConfigurationBuilder)b).processSettings;
        this.inCompounds = ((ProcessConfigurationBuilder)b).inCompounds$set ? ((ProcessConfigurationBuilder)b).inCompounds$value : ProcessConfiguration.$default$inCompounds();
        this.compounds = ((ProcessConfigurationBuilder)b).compounds$set ? ((ProcessConfigurationBuilder)b).compounds$value : ProcessConfiguration.$default$compounds();
        this.inSections = ((ProcessConfigurationBuilder)b).inSections$set ? ((ProcessConfigurationBuilder)b).inSections$value : ProcessConfiguration.$default$inSections();
        this.sections = ((ProcessConfigurationBuilder)b).sections$set ? ((ProcessConfigurationBuilder)b).sections$value : ProcessConfiguration.$default$sections();
        this.projectConfiguration = ((ProcessConfigurationBuilder)b).projectConfiguration;
    }

    public static ProcessConfigurationBuilder<?, ?> builder() {
        return new ProcessConfigurationBuilderImpl();
    }

    public ProcessConfigurationBuilder<?, ?> toBuilder() {
        return new ProcessConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public String getName() {
        return this.name;
    }

    public String getPathToFile() {
        return this.pathToFile;
    }

    public ProcessSettings getProcessSettings() {
        return this.processSettings;
    }

    public List<CompoundConfiguration> getInCompounds() {
        return this.inCompounds;
    }

    public List<String> getCompounds() {
        return this.compounds;
    }

    public List<SectionConfiguration> getInSections() {
        return this.inSections;
    }

    public List<String> getSections() {
        return this.sections;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPathToFile(String pathToFile) {
        this.pathToFile = pathToFile;
    }

    public void setProcessSettings(ProcessSettings processSettings) {
        this.processSettings = processSettings;
    }

    public void setCompounds(List<String> compounds) {
        this.compounds = compounds;
    }

    public void setSections(List<String> sections) {
        this.sections = sections;
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessConfiguration)) {
            return false;
        }
        ProcessConfiguration other = (ProcessConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$sourceId = this.getSourceId();
        UUID other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId)) {
            return false;
        }
        List<String> this$compounds = this.getCompounds();
        List<String> other$compounds = other.getCompounds();
        if (this$compounds == null ? other$compounds != null : !((Object)this$compounds).equals(other$compounds)) {
            return false;
        }
        List<String> this$sections = this.getSections();
        List<String> other$sections = other.getSections();
        return !(this$sections == null ? other$sections != null : !((Object)this$sections).equals(other$sections));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProcessConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        List<String> $compounds = this.getCompounds();
        result = result * 59 + ($compounds == null ? 43 : ((Object)$compounds).hashCode());
        List<String> $sections = this.getSections();
        result = result * 59 + ($sections == null ? 43 : ((Object)$sections).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProcessConfiguration(id=" + this.getId() + ", sourceId=" + this.getSourceId() + ", name=" + this.getName() + ", pathToFile=" + this.getPathToFile() + ", processSettings=" + this.getProcessSettings() + ", compounds=" + this.getCompounds() + ", sections=" + this.getSections() + ")";
    }

    public ProcessConfiguration(UUID id, UUID sourceId, String name, String pathToFile, ProcessSettings processSettings, List<CompoundConfiguration> inCompounds, List<String> compounds, List<SectionConfiguration> inSections, List<String> sections, ProjectConfiguration projectConfiguration) {
        this.id = id;
        this.sourceId = sourceId;
        this.name = name;
        this.pathToFile = pathToFile;
        this.processSettings = processSettings;
        this.inCompounds = inCompounds;
        this.compounds = compounds;
        this.inSections = inSections;
        this.sections = sections;
        this.projectConfiguration = projectConfiguration;
    }

    public ProcessConfiguration() {
        this.inCompounds = ProcessConfiguration.$default$inCompounds();
        this.compounds = ProcessConfiguration.$default$compounds();
        this.inSections = ProcessConfiguration.$default$inSections();
        this.sections = ProcessConfiguration.$default$sections();
    }

    public static abstract class ProcessConfigurationBuilder<C extends ProcessConfiguration, B extends ProcessConfigurationBuilder<C, B>>
    extends DateAuditorEntity.DateAuditorEntityBuilder<C, B> {
        private UUID id;
        private UUID sourceId;
        private String name;
        private String pathToFile;
        private ProcessSettings processSettings;
        private boolean inCompounds$set;
        private List<CompoundConfiguration> inCompounds$value;
        private boolean compounds$set;
        private List<String> compounds$value;
        private boolean inSections$set;
        private List<SectionConfiguration> inSections$value;
        private boolean sections$set;
        private List<String> sections$value;
        private ProjectConfiguration projectConfiguration;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ProcessConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ProcessConfiguration instance, ProcessConfigurationBuilder<?, ?> b) {
            b.id(instance.id);
            b.sourceId(instance.sourceId);
            b.name(instance.name);
            b.pathToFile(instance.pathToFile);
            b.processSettings(instance.processSettings);
            b.inCompounds(instance.inCompounds);
            b.compounds(instance.compounds);
            b.inSections(instance.inSections);
            b.sections(instance.sections);
            b.projectConfiguration(instance.projectConfiguration);
        }

        public B id(UUID id) {
            this.id = id;
            return (B)this.self();
        }

        public B sourceId(UUID sourceId) {
            this.sourceId = sourceId;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B pathToFile(String pathToFile) {
            this.pathToFile = pathToFile;
            return (B)this.self();
        }

        public B processSettings(ProcessSettings processSettings) {
            this.processSettings = processSettings;
            return (B)this.self();
        }

        public B inCompounds(List<CompoundConfiguration> inCompounds) {
            this.inCompounds$value = inCompounds;
            this.inCompounds$set = true;
            return (B)this.self();
        }

        public B compounds(List<String> compounds) {
            this.compounds$value = compounds;
            this.compounds$set = true;
            return (B)this.self();
        }

        public B inSections(List<SectionConfiguration> inSections) {
            this.inSections$value = inSections;
            this.inSections$set = true;
            return (B)this.self();
        }

        public B sections(List<String> sections) {
            this.sections$value = sections;
            this.sections$set = true;
            return (B)this.self();
        }

        public B projectConfiguration(ProjectConfiguration projectConfiguration) {
            this.projectConfiguration = projectConfiguration;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ProcessConfiguration.ProcessConfigurationBuilder(super=" + super.toString() + ", id=" + this.id + ", sourceId=" + this.sourceId + ", name=" + this.name + ", pathToFile=" + this.pathToFile + ", processSettings=" + this.processSettings + ", inCompounds$value=" + this.inCompounds$value + ", compounds$value=" + this.compounds$value + ", inSections$value=" + this.inSections$value + ", sections$value=" + this.sections$value + ", projectConfiguration=" + this.projectConfiguration + ")";
        }
    }

    private static final class ProcessConfigurationBuilderImpl
    extends ProcessConfigurationBuilder<ProcessConfiguration, ProcessConfigurationBuilderImpl> {
        private ProcessConfigurationBuilderImpl() {
        }

        @Override
        protected ProcessConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public ProcessConfiguration build() {
            return new ProcessConfiguration(this);
        }
    }
}

