/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.configuration;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.mia.exceptions.configuration.CompoundNotFoundException;
import org.qubership.atp.mia.exceptions.configuration.ProcessNotFoundException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.HeaderConfiguration;
import org.qubership.atp.mia.model.configuration.PotHeaderConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="project_configuration")
public class ProjectConfiguration
extends DateAuditorEntity {
    private static final Logger log = LoggerFactory.getLogger(ProjectConfiguration.class);
    private static final long serialVersionUID = -1488230148100162341L;
    @Id
    @Column(name="project_id")
    @DiffInclude
    private UUID projectId;
    @Column(name="project_name")
    private String projectName;
    @Column(name="git_url")
    private String gitUrl;
    @Column(name="validation_result")
    @DiffInclude
    private String validationResult;
    @Column(name="primary_migration_done")
    private boolean primaryMigrationDone;
    @Column(name="last_loaded_when")
    private LocalDateTime lastLoadedWhen;
    @OneToOne(mappedBy="projectConfiguration", targetEntity=CommonConfiguration.class, cascade={CascadeType.MERGE}, orphanRemoval=true)
    @DiffInclude
    private CommonConfiguration commonConfiguration;
    @OneToOne(mappedBy="projectConfiguration", targetEntity=HeaderConfiguration.class, cascade={CascadeType.MERGE}, orphanRemoval=true)
    @DiffInclude
    private HeaderConfiguration headerConfiguration;
    @OneToOne(mappedBy="projectConfiguration", targetEntity=PotHeaderConfiguration.class, cascade={CascadeType.MERGE}, orphanRemoval=true)
    @DiffInclude
    private PotHeaderConfiguration potHeaderConfiguration;
    @OneToMany(mappedBy="projectConfiguration", targetEntity=SectionConfiguration.class, cascade={CascadeType.MERGE}, orphanRemoval=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<SectionConfiguration> sections;
    @OneToMany(mappedBy="projectConfiguration", targetEntity=ProcessConfiguration.class, cascade={CascadeType.MERGE}, orphanRemoval=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<ProcessConfiguration> processes;
    @OneToMany(mappedBy="projectConfiguration", targetEntity=CompoundConfiguration.class, cascade={CascadeType.MERGE}, orphanRemoval=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<CompoundConfiguration> compounds;
    @OneToMany(mappedBy="projectConfiguration", targetEntity=ProjectDirectory.class, cascade={CascadeType.MERGE}, orphanRemoval=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<ProjectDirectory> directories;
    @OneToMany(mappedBy="projectConfiguration", targetEntity=ProjectFile.class, cascade={CascadeType.MERGE}, orphanRemoval=true)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<ProjectFile> files;

    public List<ProjectDirectory> getAllDirectories() {
        ArrayList<ProjectDirectory> allDirectories = new ArrayList<ProjectDirectory>();
        this.getDirectories().stream().forEach(d -> {
            allDirectories.add((ProjectDirectory)d);
            allDirectories.addAll(d.getWithChildrenDirectories());
        });
        return allDirectories;
    }

    public List<SectionConfiguration> getAllSections() {
        ArrayList<SectionConfiguration> allSections = new ArrayList<SectionConfiguration>();
        this.getSections().stream().forEach(s -> {
            if (s != null) {
                allSections.add((SectionConfiguration)s);
                allSections.addAll(s.getWithChildrenSections());
            }
        });
        return allSections;
    }

    public CommonConfiguration getCommonConfiguration() {
        if (this.commonConfiguration == null) {
            this.commonConfiguration = new CommonConfiguration();
        }
        return this.commonConfiguration;
    }

    public CompoundConfiguration getCompoundByName(String compoundName) {
        return this.getCompoundByNameSafe(compoundName).orElseThrow(() -> new CompoundNotFoundException(compoundName));
    }

    public Optional<CompoundConfiguration> getCompoundByNameSafe(String compoundName) {
        return this.compounds.stream().filter(p -> p.getName().equals(compoundName)).findAny();
    }

    public List<CompoundConfiguration> getCompounds() {
        if (this.compounds == null) {
            this.compounds = new ArrayList<CompoundConfiguration>();
        }
        return this.compounds;
    }

    public List<ProjectDirectory> getDirectories() {
        if (this.directories == null) {
            this.directories = new ArrayList<ProjectDirectory>();
        }
        return this.directories;
    }

    public List<ProjectFile> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<ProjectFile>();
        }
        return this.files;
    }

    public HeaderConfiguration getHeaderConfiguration() {
        if (this.headerConfiguration == null) {
            this.headerConfiguration = new HeaderConfiguration();
        }
        return this.headerConfiguration;
    }

    public PotHeaderConfiguration getPotHeaderConfiguration() {
        if (this.potHeaderConfiguration == null) {
            this.potHeaderConfiguration = new PotHeaderConfiguration();
        }
        return this.potHeaderConfiguration;
    }

    public ProcessConfiguration getProcessByName(String processName) {
        return this.getProcessByNameSafe(processName).orElseThrow(() -> new ProcessNotFoundException(processName));
    }

    public Optional<ProcessConfiguration> getProcessByNameSafe(String processName) {
        return this.processes.stream().filter(p -> p.getName().equals(processName)).findAny();
    }

    public List<ProcessConfiguration> getProcesses() {
        if (this.processes == null) {
            this.processes = new ArrayList<ProcessConfiguration>();
        }
        return this.processes;
    }

    public List<ProjectDirectory> getRootDirectories() {
        if (this.directories == null) {
            return new ArrayList<ProjectDirectory>();
        }
        return this.directories.stream().filter(d -> d.getParentDirectory() == null).collect(Collectors.toList());
    }

    public List<ProjectFile> getRootFiles() {
        if (this.files == null) {
            return new ArrayList<ProjectFile>();
        }
        return this.files.stream().filter(f -> f.getDirectory() == null).collect(Collectors.toList());
    }

    public LinkedList<SectionConfiguration> getRootSections() {
        LinkedList<SectionConfiguration> sectionAsRoot = new LinkedList<SectionConfiguration>();
        if (this.sections != null) {
            this.sections.stream().sorted(Comparator.comparing(SectionConfiguration::getPlace)).forEach(section -> {
                if (section.getParentSection() == null) {
                    sectionAsRoot.add(Utils.correctPlaceInList(sectionAsRoot, section.getPlace()), (SectionConfiguration)section);
                }
            });
        }
        return sectionAsRoot;
    }

    public List<SectionConfiguration> getSections() {
        if (this.sections == null) {
            this.sections = new ArrayList<SectionConfiguration>();
        }
        return this.sections;
    }

    public void removeSection(SectionConfiguration section) {
        if (this.sections != null) {
            this.sections.remove(section);
        }
    }

    protected ProjectConfiguration(ProjectConfigurationBuilder<?, ?> b) {
        super(b);
        this.projectId = ((ProjectConfigurationBuilder)b).projectId;
        this.projectName = ((ProjectConfigurationBuilder)b).projectName;
        this.gitUrl = ((ProjectConfigurationBuilder)b).gitUrl;
        this.validationResult = ((ProjectConfigurationBuilder)b).validationResult;
        this.primaryMigrationDone = ((ProjectConfigurationBuilder)b).primaryMigrationDone;
        this.lastLoadedWhen = ((ProjectConfigurationBuilder)b).lastLoadedWhen;
        this.commonConfiguration = ((ProjectConfigurationBuilder)b).commonConfiguration;
        this.headerConfiguration = ((ProjectConfigurationBuilder)b).headerConfiguration;
        this.potHeaderConfiguration = ((ProjectConfigurationBuilder)b).potHeaderConfiguration;
        this.sections = ((ProjectConfigurationBuilder)b).sections;
        this.processes = ((ProjectConfigurationBuilder)b).processes;
        this.compounds = ((ProjectConfigurationBuilder)b).compounds;
        this.directories = ((ProjectConfigurationBuilder)b).directories;
        this.files = ((ProjectConfigurationBuilder)b).files;
    }

    public static ProjectConfigurationBuilder<?, ?> builder() {
        return new ProjectConfigurationBuilderImpl();
    }

    public ProjectConfigurationBuilder<?, ?> toBuilder() {
        return new ProjectConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    public ProjectConfiguration(UUID projectId, String projectName, String gitUrl, String validationResult, boolean primaryMigrationDone, LocalDateTime lastLoadedWhen, CommonConfiguration commonConfiguration, HeaderConfiguration headerConfiguration, PotHeaderConfiguration potHeaderConfiguration, List<SectionConfiguration> sections, List<ProcessConfiguration> processes, List<CompoundConfiguration> compounds, List<ProjectDirectory> directories, List<ProjectFile> files) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.gitUrl = gitUrl;
        this.validationResult = validationResult;
        this.primaryMigrationDone = primaryMigrationDone;
        this.lastLoadedWhen = lastLoadedWhen;
        this.commonConfiguration = commonConfiguration;
        this.headerConfiguration = headerConfiguration;
        this.potHeaderConfiguration = potHeaderConfiguration;
        this.sections = sections;
        this.processes = processes;
        this.compounds = compounds;
        this.directories = directories;
        this.files = files;
    }

    public ProjectConfiguration() {
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public String getValidationResult() {
        return this.validationResult;
    }

    public boolean isPrimaryMigrationDone() {
        return this.primaryMigrationDone;
    }

    public LocalDateTime getLastLoadedWhen() {
        return this.lastLoadedWhen;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }

    public void setValidationResult(String validationResult) {
        this.validationResult = validationResult;
    }

    public void setPrimaryMigrationDone(boolean primaryMigrationDone) {
        this.primaryMigrationDone = primaryMigrationDone;
    }

    public void setLastLoadedWhen(LocalDateTime lastLoadedWhen) {
        this.lastLoadedWhen = lastLoadedWhen;
    }

    public void setCommonConfiguration(CommonConfiguration commonConfiguration) {
        this.commonConfiguration = commonConfiguration;
    }

    public void setHeaderConfiguration(HeaderConfiguration headerConfiguration) {
        this.headerConfiguration = headerConfiguration;
    }

    public void setPotHeaderConfiguration(PotHeaderConfiguration potHeaderConfiguration) {
        this.potHeaderConfiguration = potHeaderConfiguration;
    }

    public void setSections(List<SectionConfiguration> sections) {
        this.sections = sections;
    }

    public void setProcesses(List<ProcessConfiguration> processes) {
        this.processes = processes;
    }

    public void setCompounds(List<CompoundConfiguration> compounds) {
        this.compounds = compounds;
    }

    public void setDirectories(List<ProjectDirectory> directories) {
        this.directories = directories;
    }

    public void setFiles(List<ProjectFile> files) {
        this.files = files;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectConfiguration)) {
            return false;
        }
        ProjectConfiguration other = (ProjectConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrimaryMigrationDone() != other.isPrimaryMigrationDone()) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$gitUrl = this.getGitUrl();
        String other$gitUrl = other.getGitUrl();
        if (this$gitUrl == null ? other$gitUrl != null : !this$gitUrl.equals(other$gitUrl)) {
            return false;
        }
        String this$validationResult = this.getValidationResult();
        String other$validationResult = other.getValidationResult();
        if (this$validationResult == null ? other$validationResult != null : !this$validationResult.equals(other$validationResult)) {
            return false;
        }
        LocalDateTime this$lastLoadedWhen = this.getLastLoadedWhen();
        LocalDateTime other$lastLoadedWhen = other.getLastLoadedWhen();
        if (this$lastLoadedWhen == null ? other$lastLoadedWhen != null : !((Object)this$lastLoadedWhen).equals(other$lastLoadedWhen)) {
            return false;
        }
        CommonConfiguration this$commonConfiguration = this.getCommonConfiguration();
        CommonConfiguration other$commonConfiguration = other.getCommonConfiguration();
        if (this$commonConfiguration == null ? other$commonConfiguration != null : !((Object)this$commonConfiguration).equals(other$commonConfiguration)) {
            return false;
        }
        HeaderConfiguration this$headerConfiguration = this.getHeaderConfiguration();
        HeaderConfiguration other$headerConfiguration = other.getHeaderConfiguration();
        if (this$headerConfiguration == null ? other$headerConfiguration != null : !((Object)this$headerConfiguration).equals(other$headerConfiguration)) {
            return false;
        }
        PotHeaderConfiguration this$potHeaderConfiguration = this.getPotHeaderConfiguration();
        PotHeaderConfiguration other$potHeaderConfiguration = other.getPotHeaderConfiguration();
        if (this$potHeaderConfiguration == null ? other$potHeaderConfiguration != null : !((Object)this$potHeaderConfiguration).equals(other$potHeaderConfiguration)) {
            return false;
        }
        List<SectionConfiguration> this$sections = this.getSections();
        List<SectionConfiguration> other$sections = other.getSections();
        if (this$sections == null ? other$sections != null : !((Object)this$sections).equals(other$sections)) {
            return false;
        }
        List<ProcessConfiguration> this$processes = this.getProcesses();
        List<ProcessConfiguration> other$processes = other.getProcesses();
        if (this$processes == null ? other$processes != null : !((Object)this$processes).equals(other$processes)) {
            return false;
        }
        List<CompoundConfiguration> this$compounds = this.getCompounds();
        List<CompoundConfiguration> other$compounds = other.getCompounds();
        if (this$compounds == null ? other$compounds != null : !((Object)this$compounds).equals(other$compounds)) {
            return false;
        }
        List<ProjectDirectory> this$directories = this.getDirectories();
        List<ProjectDirectory> other$directories = other.getDirectories();
        if (this$directories == null ? other$directories != null : !((Object)this$directories).equals(other$directories)) {
            return false;
        }
        List<ProjectFile> this$files = this.getFiles();
        List<ProjectFile> other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProjectConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrimaryMigrationDone() ? 79 : 97);
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $gitUrl = this.getGitUrl();
        result = result * 59 + ($gitUrl == null ? 43 : $gitUrl.hashCode());
        String $validationResult = this.getValidationResult();
        result = result * 59 + ($validationResult == null ? 43 : $validationResult.hashCode());
        LocalDateTime $lastLoadedWhen = this.getLastLoadedWhen();
        result = result * 59 + ($lastLoadedWhen == null ? 43 : ((Object)$lastLoadedWhen).hashCode());
        CommonConfiguration $commonConfiguration = this.getCommonConfiguration();
        result = result * 59 + ($commonConfiguration == null ? 43 : ((Object)$commonConfiguration).hashCode());
        HeaderConfiguration $headerConfiguration = this.getHeaderConfiguration();
        result = result * 59 + ($headerConfiguration == null ? 43 : ((Object)$headerConfiguration).hashCode());
        PotHeaderConfiguration $potHeaderConfiguration = this.getPotHeaderConfiguration();
        result = result * 59 + ($potHeaderConfiguration == null ? 43 : ((Object)$potHeaderConfiguration).hashCode());
        List<SectionConfiguration> $sections = this.getSections();
        result = result * 59 + ($sections == null ? 43 : ((Object)$sections).hashCode());
        List<ProcessConfiguration> $processes = this.getProcesses();
        result = result * 59 + ($processes == null ? 43 : ((Object)$processes).hashCode());
        List<CompoundConfiguration> $compounds = this.getCompounds();
        result = result * 59 + ($compounds == null ? 43 : ((Object)$compounds).hashCode());
        List<ProjectDirectory> $directories = this.getDirectories();
        result = result * 59 + ($directories == null ? 43 : ((Object)$directories).hashCode());
        List<ProjectFile> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProjectConfiguration(projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", gitUrl=" + this.getGitUrl() + ", validationResult=" + this.getValidationResult() + ", primaryMigrationDone=" + this.isPrimaryMigrationDone() + ", lastLoadedWhen=" + this.getLastLoadedWhen() + ", commonConfiguration=" + this.getCommonConfiguration() + ", headerConfiguration=" + this.getHeaderConfiguration() + ", potHeaderConfiguration=" + this.getPotHeaderConfiguration() + ", sections=" + this.getSections() + ", processes=" + this.getProcesses() + ", compounds=" + this.getCompounds() + ", directories=" + this.getDirectories() + ", files=" + this.getFiles() + ")";
    }

    public static abstract class ProjectConfigurationBuilder<C extends ProjectConfiguration, B extends ProjectConfigurationBuilder<C, B>>
    extends DateAuditorEntity.DateAuditorEntityBuilder<C, B> {
        private UUID projectId;
        private String projectName;
        private String gitUrl;
        private String validationResult;
        private boolean primaryMigrationDone;
        private LocalDateTime lastLoadedWhen;
        private CommonConfiguration commonConfiguration;
        private HeaderConfiguration headerConfiguration;
        private PotHeaderConfiguration potHeaderConfiguration;
        private List<SectionConfiguration> sections;
        private List<ProcessConfiguration> processes;
        private List<CompoundConfiguration> compounds;
        private List<ProjectDirectory> directories;
        private List<ProjectFile> files;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ProjectConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ProjectConfiguration instance, ProjectConfigurationBuilder<?, ?> b) {
            b.projectId(instance.projectId);
            b.projectName(instance.projectName);
            b.gitUrl(instance.gitUrl);
            b.validationResult(instance.validationResult);
            b.primaryMigrationDone(instance.primaryMigrationDone);
            b.lastLoadedWhen(instance.lastLoadedWhen);
            b.commonConfiguration(instance.commonConfiguration);
            b.headerConfiguration(instance.headerConfiguration);
            b.potHeaderConfiguration(instance.potHeaderConfiguration);
            b.sections(instance.sections);
            b.processes(instance.processes);
            b.compounds(instance.compounds);
            b.directories(instance.directories);
            b.files(instance.files);
        }

        public B projectId(UUID projectId) {
            this.projectId = projectId;
            return (B)this.self();
        }

        public B projectName(String projectName) {
            this.projectName = projectName;
            return (B)this.self();
        }

        public B gitUrl(String gitUrl) {
            this.gitUrl = gitUrl;
            return (B)this.self();
        }

        public B validationResult(String validationResult) {
            this.validationResult = validationResult;
            return (B)this.self();
        }

        public B primaryMigrationDone(boolean primaryMigrationDone) {
            this.primaryMigrationDone = primaryMigrationDone;
            return (B)this.self();
        }

        public B lastLoadedWhen(LocalDateTime lastLoadedWhen) {
            this.lastLoadedWhen = lastLoadedWhen;
            return (B)this.self();
        }

        public B commonConfiguration(CommonConfiguration commonConfiguration) {
            this.commonConfiguration = commonConfiguration;
            return (B)this.self();
        }

        public B headerConfiguration(HeaderConfiguration headerConfiguration) {
            this.headerConfiguration = headerConfiguration;
            return (B)this.self();
        }

        public B potHeaderConfiguration(PotHeaderConfiguration potHeaderConfiguration) {
            this.potHeaderConfiguration = potHeaderConfiguration;
            return (B)this.self();
        }

        public B sections(List<SectionConfiguration> sections) {
            this.sections = sections;
            return (B)this.self();
        }

        public B processes(List<ProcessConfiguration> processes) {
            this.processes = processes;
            return (B)this.self();
        }

        public B compounds(List<CompoundConfiguration> compounds) {
            this.compounds = compounds;
            return (B)this.self();
        }

        public B directories(List<ProjectDirectory> directories) {
            this.directories = directories;
            return (B)this.self();
        }

        public B files(List<ProjectFile> files) {
            this.files = files;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ProjectConfiguration.ProjectConfigurationBuilder(super=" + super.toString() + ", projectId=" + this.projectId + ", projectName=" + this.projectName + ", gitUrl=" + this.gitUrl + ", validationResult=" + this.validationResult + ", primaryMigrationDone=" + this.primaryMigrationDone + ", lastLoadedWhen=" + this.lastLoadedWhen + ", commonConfiguration=" + this.commonConfiguration + ", headerConfiguration=" + this.headerConfiguration + ", potHeaderConfiguration=" + this.potHeaderConfiguration + ", sections=" + this.sections + ", processes=" + this.processes + ", compounds=" + this.compounds + ", directories=" + this.directories + ", files=" + this.files + ")";
        }
    }

    private static final class ProjectConfigurationBuilderImpl
    extends ProjectConfigurationBuilder<ProjectConfiguration, ProjectConfigurationBuilderImpl> {
        private ProjectConfigurationBuilderImpl() {
        }

        @Override
        protected ProjectConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public ProjectConfiguration build() {
            return new ProjectConfiguration(this);
        }
    }
}

