/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.PostRemove;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.utils.Utils;

@Entity
@Table(name="project_section_configuration")
public class SectionConfiguration
extends DateAuditorEntity {
    private static final long serialVersionUID = -640501254431769898L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id", nullable=false)
    @DiffInclude
    protected UUID id;
    @Column(name="source_id")
    private UUID sourceId;
    @Column(name="section_name", nullable=false)
    @DiffInclude
    private String name;
    @Column(name="place", nullable=false)
    @DiffInclude
    private int place;
    @ManyToOne(targetEntity=SectionConfiguration.class, cascade={CascadeType.MERGE})
    @JoinColumn(name="parent_id")
    @DiffInclude
    private SectionConfiguration parentSection;
    @OneToMany(mappedBy="parentSection", cascade={CascadeType.ALL})
    @OrderColumn(name="place", nullable=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffInclude
    private List<SectionConfiguration> sections;
    @ManyToMany(targetEntity=CompoundConfiguration.class, cascade={CascadeType.MERGE})
    @JoinTable(name="project_section_compound_configuration", joinColumns={@JoinColumn(name="section_id")}, inverseJoinColumns={@JoinColumn(name="compound_id")})
    @OrderColumn(name="place")
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffInclude
    private List<CompoundConfiguration> compounds;
    @ManyToMany(targetEntity=ProcessConfiguration.class, cascade={CascadeType.MERGE})
    @JoinTable(name="project_section_process_configuration", joinColumns={@JoinColumn(name="section_id")}, inverseJoinColumns={@JoinColumn(name="process_id")})
    @OrderColumn(name="place")
    @Fetch(value=FetchMode.SUBSELECT)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @DiffInclude
    private List<ProcessConfiguration> processes;
    @ManyToOne(targetEntity=ProjectConfiguration.class)
    @JoinColumn(name="project_id", nullable=false)
    @DiffIgnore
    private ProjectConfiguration projectConfiguration;

    public void addCompound(CompoundConfiguration compoundConfiguration) {
        if (this.compounds == null) {
            this.compounds = new ArrayList<CompoundConfiguration>();
        }
        if (this.compounds.stream().noneMatch(c -> c.getId() != null && c.getId().equals(compoundConfiguration.getId()))) {
            this.compounds.add(compoundConfiguration);
        }
    }

    public void addProcess(ProcessConfiguration processConfiguration) {
        if (this.processes == null) {
            this.processes = new ArrayList<ProcessConfiguration>();
        }
        if (this.processes.stream().noneMatch(p -> p.getId() != null && p.getId().equals(processConfiguration.getId()))) {
            this.processes.add(processConfiguration);
        }
    }

    public void addSection(SectionConfiguration sectionConfiguration) {
        if (this.sections == null) {
            this.sections = new ArrayList<SectionConfiguration>();
        }
        if (this.sections.stream().noneMatch(s -> s.getId() != null && s.getId().equals(sectionConfiguration.getId()))) {
            this.sections.add(sectionConfiguration);
        }
    }

    public Set<UUID> getChildrenUuid() {
        HashSet<UUID> childsUuid = new HashSet<UUID>();
        this.getSections().forEach(s -> {
            if (s != null) {
                childsUuid.add(s.getId());
                childsUuid.addAll(s.getChildrenUuid());
            }
        });
        return childsUuid;
    }

    public List<SectionConfiguration> getSections() {
        if (this.sections == null) {
            this.sections = new ArrayList<SectionConfiguration>();
        }
        return this.sections;
    }

    public List<SectionConfiguration> getWithChildrenSections() {
        ArrayList<SectionConfiguration> sections = new ArrayList<SectionConfiguration>();
        this.getSections().forEach(s -> {
            if (s != null) {
                sections.add((SectionConfiguration)s);
                sections.addAll(s.getWithChildrenSections());
            }
        });
        return sections;
    }

    @PrePersist
    @PreUpdate
    @PostRemove
    public void reorderChildSequentially() {
        if (this.sections != null) {
            ArrayList orderedSections = new ArrayList();
            this.sections.stream().filter(Objects::nonNull).forEach(s -> orderedSections.add(Utils.correctPlaceInList(orderedSections, s.place), s));
            IntStream.range(0, orderedSections.size()).forEach(place -> ((SectionConfiguration)orderedSections.get(place)).setPlace(place));
        }
    }

    private static int $default$place() {
        return 0;
    }

    private static List<CompoundConfiguration> $default$compounds() {
        return new ArrayList<CompoundConfiguration>();
    }

    private static List<ProcessConfiguration> $default$processes() {
        return new ArrayList<ProcessConfiguration>();
    }

    protected SectionConfiguration(SectionConfigurationBuilder<?, ?> b) {
        super(b);
        this.id = ((SectionConfigurationBuilder)b).id;
        this.sourceId = ((SectionConfigurationBuilder)b).sourceId;
        this.name = ((SectionConfigurationBuilder)b).name;
        this.place = ((SectionConfigurationBuilder)b).place$set ? ((SectionConfigurationBuilder)b).place$value : SectionConfiguration.$default$place();
        this.parentSection = ((SectionConfigurationBuilder)b).parentSection;
        this.sections = ((SectionConfigurationBuilder)b).sections;
        this.compounds = ((SectionConfigurationBuilder)b).compounds$set ? ((SectionConfigurationBuilder)b).compounds$value : SectionConfiguration.$default$compounds();
        this.processes = ((SectionConfigurationBuilder)b).processes$set ? ((SectionConfigurationBuilder)b).processes$value : SectionConfiguration.$default$processes();
        this.projectConfiguration = ((SectionConfigurationBuilder)b).projectConfiguration;
    }

    public static SectionConfigurationBuilder<?, ?> builder() {
        return new SectionConfigurationBuilderImpl();
    }

    public SectionConfigurationBuilder<?, ?> toBuilder() {
        return new SectionConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public String getName() {
        return this.name;
    }

    public int getPlace() {
        return this.place;
    }

    public SectionConfiguration getParentSection() {
        return this.parentSection;
    }

    public List<CompoundConfiguration> getCompounds() {
        return this.compounds;
    }

    public List<ProcessConfiguration> getProcesses() {
        return this.processes;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPlace(int place) {
        this.place = place;
    }

    public void setParentSection(SectionConfiguration parentSection) {
        this.parentSection = parentSection;
    }

    public void setSections(List<SectionConfiguration> sections) {
        this.sections = sections;
    }

    public void setCompounds(List<CompoundConfiguration> compounds) {
        this.compounds = compounds;
    }

    public void setProcesses(List<ProcessConfiguration> processes) {
        this.processes = processes;
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    @Override
    public String toString() {
        return "SectionConfiguration(id=" + this.getId() + ", sourceId=" + this.getSourceId() + ", name=" + this.getName() + ", place=" + this.getPlace() + ", sections=" + this.getSections() + ", compounds=" + this.getCompounds() + ", processes=" + this.getProcesses() + ")";
    }

    public SectionConfiguration(UUID id, UUID sourceId, String name, int place, SectionConfiguration parentSection, List<SectionConfiguration> sections, List<CompoundConfiguration> compounds, List<ProcessConfiguration> processes, ProjectConfiguration projectConfiguration) {
        this.id = id;
        this.sourceId = sourceId;
        this.name = name;
        this.place = place;
        this.parentSection = parentSection;
        this.sections = sections;
        this.compounds = compounds;
        this.processes = processes;
        this.projectConfiguration = projectConfiguration;
    }

    public SectionConfiguration() {
        this.place = SectionConfiguration.$default$place();
        this.compounds = SectionConfiguration.$default$compounds();
        this.processes = SectionConfiguration.$default$processes();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SectionConfiguration)) {
            return false;
        }
        SectionConfiguration other = (SectionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$sourceId = this.getSourceId();
        UUID other$sourceId = other.getSourceId();
        return !(this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SectionConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        return result;
    }

    public static abstract class SectionConfigurationBuilder<C extends SectionConfiguration, B extends SectionConfigurationBuilder<C, B>>
    extends DateAuditorEntity.DateAuditorEntityBuilder<C, B> {
        private UUID id;
        private UUID sourceId;
        private String name;
        private boolean place$set;
        private int place$value;
        private SectionConfiguration parentSection;
        private List<SectionConfiguration> sections;
        private boolean compounds$set;
        private List<CompoundConfiguration> compounds$value;
        private boolean processes$set;
        private List<ProcessConfiguration> processes$value;
        private ProjectConfiguration projectConfiguration;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SectionConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SectionConfiguration instance, SectionConfigurationBuilder<?, ?> b) {
            b.id(instance.id);
            b.sourceId(instance.sourceId);
            b.name(instance.name);
            b.place(instance.place);
            b.parentSection(instance.parentSection);
            b.sections(instance.sections);
            b.compounds(instance.compounds);
            b.processes(instance.processes);
            b.projectConfiguration(instance.projectConfiguration);
        }

        public B id(UUID id) {
            this.id = id;
            return (B)this.self();
        }

        public B sourceId(UUID sourceId) {
            this.sourceId = sourceId;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B place(int place) {
            this.place$value = place;
            this.place$set = true;
            return (B)this.self();
        }

        public B parentSection(SectionConfiguration parentSection) {
            this.parentSection = parentSection;
            return (B)this.self();
        }

        public B sections(List<SectionConfiguration> sections) {
            this.sections = sections;
            return (B)this.self();
        }

        public B compounds(List<CompoundConfiguration> compounds) {
            this.compounds$value = compounds;
            this.compounds$set = true;
            return (B)this.self();
        }

        public B processes(List<ProcessConfiguration> processes) {
            this.processes$value = processes;
            this.processes$set = true;
            return (B)this.self();
        }

        public B projectConfiguration(ProjectConfiguration projectConfiguration) {
            this.projectConfiguration = projectConfiguration;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SectionConfiguration.SectionConfigurationBuilder(super=" + super.toString() + ", id=" + this.id + ", sourceId=" + this.sourceId + ", name=" + this.name + ", place$value=" + this.place$value + ", parentSection=" + this.parentSection + ", sections=" + this.sections + ", compounds$value=" + this.compounds$value + ", processes$value=" + this.processes$value + ", projectConfiguration=" + this.projectConfiguration + ")";
        }
    }

    private static final class SectionConfigurationBuilderImpl
    extends SectionConfigurationBuilder<SectionConfiguration, SectionConfigurationBuilderImpl> {
        private SectionConfigurationBuilderImpl() {
        }

        @Override
        protected SectionConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public SectionConfiguration build() {
            return new SectionConfiguration(this);
        }
    }
}

