/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.ei;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.ei.ExportImportIdentifier;

public class ExportImportCompound
extends ExportImportIdentifier {
    private static final long serialVersionUID = 2951806177295221501L;
    private List<UUID> inSections;
    private List<UUID> processes;
    private String referToInput;

    public ExportImportCompound(CompoundConfiguration c) {
        super(c.getId(), c.getName(), c.getProjectConfiguration().getProjectId(), c.getSourceId());
        this.referToInput = c.getReferToInput();
        if (c.getInSections() != null) {
            this.inSections = c.getInSections().stream().filter(Objects::nonNull).map(SectionConfiguration::getId).collect(Collectors.toList());
        }
        if (c.getProcesses() != null) {
            this.processes = c.getProcesses().stream().filter(Objects::nonNull).map(ProcessConfiguration::getId).collect(Collectors.toList());
        }
    }

    public List<UUID> getInSections() {
        return this.inSections;
    }

    public List<UUID> getProcesses() {
        return this.processes;
    }

    public String getReferToInput() {
        return this.referToInput;
    }

    public void setInSections(List<UUID> inSections) {
        this.inSections = inSections;
    }

    public void setProcesses(List<UUID> processes) {
        this.processes = processes;
    }

    public void setReferToInput(String referToInput) {
        this.referToInput = referToInput;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportImportCompound)) {
            return false;
        }
        ExportImportCompound other = (ExportImportCompound)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<UUID> this$inSections = this.getInSections();
        List<UUID> other$inSections = other.getInSections();
        if (this$inSections == null ? other$inSections != null : !((Object)this$inSections).equals(other$inSections)) {
            return false;
        }
        List<UUID> this$processes = this.getProcesses();
        List<UUID> other$processes = other.getProcesses();
        if (this$processes == null ? other$processes != null : !((Object)this$processes).equals(other$processes)) {
            return false;
        }
        String this$referToInput = this.getReferToInput();
        String other$referToInput = other.getReferToInput();
        return !(this$referToInput == null ? other$referToInput != null : !this$referToInput.equals(other$referToInput));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExportImportCompound;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<UUID> $inSections = this.getInSections();
        result = result * 59 + ($inSections == null ? 43 : ((Object)$inSections).hashCode());
        List<UUID> $processes = this.getProcesses();
        result = result * 59 + ($processes == null ? 43 : ((Object)$processes).hashCode());
        String $referToInput = this.getReferToInput();
        result = result * 59 + ($referToInput == null ? 43 : $referToInput.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ExportImportCompound(super=" + super.toString() + ", inSections=" + this.getInSections() + ", processes=" + this.getProcesses() + ", referToInput=" + this.getReferToInput() + ")";
    }

    public ExportImportCompound() {
    }
}

