/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.environment;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.mia.model.environment.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private static final int MILLISECONDS = 1000;
    private static final int CHANNELS_PER_SESSION = 10;
    private final Connection connection;
    private final String name;

    public Server(Connection connection, String name) {
        this.name = name;
        this.connection = connection;
    }

    public String getName() {
        return this.name;
    }

    public String getUser() {
        return this.getProperty(this.name + "_login");
    }

    public String getPass() {
        return this.getProperty(this.name + "_password");
    }

    public String getKey() {
        return this.getProperty(this.name + "_key");
    }

    public String getPassPhrase() {
        return this.getProperty("passphrase");
    }

    public boolean getPty() {
        String pty = this.getProperty(this.name + "_pty");
        if (pty != null) {
            try {
                return Boolean.parseBoolean(pty);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public int getTimeoutConnect() {
        return this.getTimeout("connect", 60000, 60000);
    }

    public int getTimeoutConnect(int defaultValue, int maxValue) {
        return this.getTimeout("connect", defaultValue * 1000, maxValue * 1000);
    }

    public int getTimeoutExecute() {
        return this.getTimeout("execute", 3600000, 3600000);
    }

    public int getTimeoutExecute(int defaultValue, int maxValue) {
        return this.getTimeout("execute", defaultValue * 1000, maxValue * 1000);
    }

    public long getTimeOutFileDownload() {
        String timeOut = this.getProperty(this.name + "_timeOutFileDownload");
        long duration = 0L;
        if (timeOut != null) {
            try {
                return (long)Float.parseFloat(timeOut);
            }
            catch (Exception e) {
                return duration;
            }
        }
        return duration;
    }

    public String getSshServerKexAlgorithms() {
        return this.getProperty(this.name + "_kex");
    }

    public String getProperty(String key) {
        if (this.connection != null && this.connection.getParameters() != null) {
            return this.connection.getParameters().get(key);
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return this.connection.getParameters();
    }

    public String getHostFull() {
        return this.getProperty(this.name + "_host");
    }

    public String getHost() {
        Pattern pattern = Pattern.compile("([^:^]*)(:\\d*)?(.*)?");
        Matcher matcher = pattern.matcher(this.getHostFull());
        matcher.find();
        String host = matcher.group(1);
        return host;
    }

    public int getPort() {
        String host = this.getHostFull();
        int port = 22;
        if (host.contains(":")) {
            String[] arr = host.split(":");
            try {
                port = Integer.parseInt(arr[arr.length - 1]);
            }
            catch (NumberFormatException ignore) {
                LOGGER.debug("use default port 22 for host [{}]", (Object)host);
            }
        }
        return port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Server server = (Server)o;
        return Objects.equals(this.connection, server.connection) && Objects.equals(this.name, server.name);
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.name);
    }

    private int getTimeout(String timeoutPostfix, int defaultValue, int maxValue) {
        String timeout = this.getProperty(this.name + "_timeout_" + timeoutPostfix);
        if (timeout != null) {
            try {
                int t = Integer.parseInt(timeout);
                return t > maxValue ? maxValue : Math.max(t, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int getChannelsPerSession() {
        String valName = "_channelsPerSession";
        return Server.parseIntOrDefault(this.getProperty(this.name + valName), 10, valName);
    }

    private static int parseIntOrDefault(String valueToParse, int defaultValue, String valueName) {
        int tempValue;
        try {
            tempValue = Integer.parseInt(valueToParse);
        }
        catch (NumberFormatException e) {
            tempValue = defaultValue;
            LOGGER.trace("Error can't parse {} value [{}], use the standard [{}]", new Object[]{valueName, valueToParse, defaultValue});
        }
        return tempValue;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String toString() {
        return "Server{name='" + this.name + ", host=" + this.getHostFull() + '}';
    }

    public static enum ConnectionType {
        SSH("ssh"),
        DB("db"),
        HTTP("http");

        private String type;

        private ConnectionType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

