/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.event;

import clover.org.apache.commons.lang3.Range;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.qubership.atp.mia.model.impl.event.EventExcelCustomer;
import org.qubership.atp.mia.model.impl.event.EventExcelMetricService;
import org.qubership.atp.mia.utils.ExcelParserHelper;

public class EventExcelProjectOne
extends EventExcelCustomer {
    private static final String DESCRIPTION = "Description";

    EventExcelProjectOne(@Nonnull XSSFSheet sheet, @Nullable String scenario, @Nullable String testCase) {
        super(sheet, scenario, testCase);
        this.eventInfoRange = Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(15));
        this.headerRowRange = Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(16));
        this.attrNameRowNumber = 16;
        this.identifications = new HashMap();
        this.identifications.put("Scenario", false);
        this.identifications.put(DESCRIPTION, false);
    }

    @Override
    public void parse() throws IllegalArgumentException {
        EventExcelMetricService.metricsAggregateServiceStatic.eventFromExcelCallStarted();
        this.defineCellsWithData("Scenario", this.scenario, DESCRIPTION, this.testCase);
        super.parse();
    }

    @Override
    protected void defineCellsWithData(@Nonnull String parentHeaderName, @Nonnull String parentHeaderValue, @Nonnull String childHeaderName, @Nullable String childHeaderValue) {
        parentHeaderValue = Strings.isNullOrEmpty((String)parentHeaderValue) ? ".+?" : parentHeaderValue;
        int parentColumn = ExcelParserHelper.getHeaderByPattern(parentHeaderName, (Range<Integer>)this.headerRowRange, this.sheet).getColumnIndex();
        Set<XSSFCell> parentCells = ExcelParserHelper.getAllCellsByPatternFromRow(parentHeaderValue, parentColumn, (Integer)this.headerRowRange.getMaximum() + 1, this.sheet);
        parentCells.forEach(pCell -> {
            XSSFCell dataCell;
            String dataValue;
            int childColumn = ExcelParserHelper.getHeaderByPattern(childHeaderName, (Range<Integer>)this.headerRowRange, this.sheet).getColumnIndex();
            int rowIdx = pCell.getRowIndex() + 1;
            while (!Strings.isNullOrEmpty((String)(dataValue = ExcelParserHelper.getCellValue(dataCell = ExcelParserHelper.getCell(rowIdx, childColumn, this.sheet))))) {
                if (Strings.isNullOrEmpty((String)childHeaderValue)) {
                    this.cellsWithData.add(dataCell);
                } else if (dataValue.matches(childHeaderValue)) {
                    this.cellsWithData.add(dataCell);
                }
                ++rowIdx;
            }
        });
    }
}

