/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.executable;

import java.io.Serializable;
import org.qubership.atp.mia.exceptions.runtimeerrors.UnsupportedCommandTypeException;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CommandType implements Serializable
{
    SSH,
    SSH_CheckFileOnServer,
    SSH_TransferFile,
    SSH_GenerationFile,
    SSH_DownloadFiles,
    SSH_UploadFile,
    SSH_UploadFileAndDownloadResult,
    SSH_GenerateEvent,
    SQL,
    REST,
    SOAP,
    SOAP_FROM_TEST_DATA,
    REST_FROM_TEST_DATA,
    VALIDATE_TEST_DATA,
    EVENT_TEST_DATA,
    SSH_FROM_TEST_DATA,
    SQL_FROM_TEST_DATA;

    private static final Logger log;
    @Deprecated
    public static final String COMMAND_ON_LOCALHOST = "COMMAND_ON_LOCALHOST";

    public static boolean isTestData(CommandType commandType) {
        switch (commandType.ordinal()) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static CommandResponse.CommandResponseType getResponseType(CommandType commandType) {
        CommandResponse.CommandResponseType result;
        switch (commandType.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                result = CommandResponse.CommandResponseType.SSH;
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 16: {
                result = CommandResponse.CommandResponseType.SQL;
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                result = CommandResponse.CommandResponseType.REST;
                break;
            }
            default: {
                throw new UnsupportedCommandTypeException(commandType);
            }
        }
        return result;
    }

    static {
        log = LoggerFactory.getLogger(CommandType.class);
    }
}

