/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.executable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.executable.Input;
import org.qubership.atp.mia.model.impl.executable.Prerequisite;
import org.qubership.atp.mia.model.impl.executable.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSettings
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ProcessSettings.class);
    private static final long serialVersionUID = -5699515696527707001L;
    private String name;
    private List<Input> inputs;
    private List<Validation> currentStatement;
    private String referToInput;
    private List<Prerequisite> prerequisites;
    private Command command;
    private List<Validation> validations;
    private HashMap<String, String> globalVariables;

    public ProcessSettings(@Nonnull String name) {
        this.name = name;
    }

    public boolean check() {
        return this.name != null && this.command != null;
    }

    public void addPrerequisites(Prerequisite prerequisite) {
        if (this.prerequisites == null) {
            this.prerequisites = new ArrayList<Prerequisite>();
        }
        this.prerequisites.add(prerequisite);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessSettings processSettings = (ProcessSettings)o;
        return Objects.equals(this.name, processSettings.name) && Objects.equals(this.inputs, processSettings.inputs) && Objects.equals(this.prerequisites, processSettings.prerequisites) && Objects.equals(this.command, processSettings.command) && Objects.equals(this.validations, processSettings.validations) && Objects.equals(this.globalVariables, processSettings.globalVariables);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.inputs, this.prerequisites, this.command, this.validations);
    }

    public String toString() {
        return new StringJoiner(", ", ProcessSettings.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("inputs=" + this.inputs).add("prerequisites=" + this.prerequisites).add("command=" + this.command).add("validations=" + this.validations).add("globalVariables=" + this.globalVariables).toString();
    }

    protected ProcessSettings(ProcessSettingsBuilder<?, ?> b) {
        this.name = ((ProcessSettingsBuilder)b).name;
        this.inputs = ((ProcessSettingsBuilder)b).inputs;
        this.currentStatement = ((ProcessSettingsBuilder)b).currentStatement;
        this.referToInput = ((ProcessSettingsBuilder)b).referToInput;
        this.prerequisites = ((ProcessSettingsBuilder)b).prerequisites;
        this.command = ((ProcessSettingsBuilder)b).command;
        this.validations = ((ProcessSettingsBuilder)b).validations;
        this.globalVariables = ((ProcessSettingsBuilder)b).globalVariables;
    }

    public static ProcessSettingsBuilder<?, ?> builder() {
        return new ProcessSettingsBuilderImpl();
    }

    public ProcessSettingsBuilder<?, ?> toBuilder() {
        return new ProcessSettingsBuilderImpl().$fillValuesFrom(this);
    }

    public String getName() {
        return this.name;
    }

    public List<Input> getInputs() {
        return this.inputs;
    }

    public List<Validation> getCurrentStatement() {
        return this.currentStatement;
    }

    public String getReferToInput() {
        return this.referToInput;
    }

    public List<Prerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    public Command getCommand() {
        return this.command;
    }

    public List<Validation> getValidations() {
        return this.validations;
    }

    public HashMap<String, String> getGlobalVariables() {
        return this.globalVariables;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInputs(List<Input> inputs) {
        this.inputs = inputs;
    }

    public void setCurrentStatement(List<Validation> currentStatement) {
        this.currentStatement = currentStatement;
    }

    public void setReferToInput(String referToInput) {
        this.referToInput = referToInput;
    }

    public void setPrerequisites(List<Prerequisite> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public void setValidations(List<Validation> validations) {
        this.validations = validations;
    }

    public void setGlobalVariables(HashMap<String, String> globalVariables) {
        this.globalVariables = globalVariables;
    }

    public ProcessSettings(String name, List<Input> inputs, List<Validation> currentStatement, String referToInput, List<Prerequisite> prerequisites, Command command, List<Validation> validations, HashMap<String, String> globalVariables) {
        this.name = name;
        this.inputs = inputs;
        this.currentStatement = currentStatement;
        this.referToInput = referToInput;
        this.prerequisites = prerequisites;
        this.command = command;
        this.validations = validations;
        this.globalVariables = globalVariables;
    }

    public ProcessSettings() {
    }

    public static abstract class ProcessSettingsBuilder<C extends ProcessSettings, B extends ProcessSettingsBuilder<C, B>> {
        private String name;
        private List<Input> inputs;
        private List<Validation> currentStatement;
        private String referToInput;
        private List<Prerequisite> prerequisites;
        private Command command;
        private List<Validation> validations;
        private HashMap<String, String> globalVariables;

        protected B $fillValuesFrom(C instance) {
            ProcessSettingsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ProcessSettings instance, ProcessSettingsBuilder<?, ?> b) {
            b.name(instance.name);
            b.inputs(instance.inputs);
            b.currentStatement(instance.currentStatement);
            b.referToInput(instance.referToInput);
            b.prerequisites(instance.prerequisites);
            b.command(instance.command);
            b.validations(instance.validations);
            b.globalVariables(instance.globalVariables);
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B inputs(List<Input> inputs) {
            this.inputs = inputs;
            return this.self();
        }

        public B currentStatement(List<Validation> currentStatement) {
            this.currentStatement = currentStatement;
            return this.self();
        }

        public B referToInput(String referToInput) {
            this.referToInput = referToInput;
            return this.self();
        }

        public B prerequisites(List<Prerequisite> prerequisites) {
            this.prerequisites = prerequisites;
            return this.self();
        }

        public B command(Command command) {
            this.command = command;
            return this.self();
        }

        public B validations(List<Validation> validations) {
            this.validations = validations;
            return this.self();
        }

        public B globalVariables(HashMap<String, String> globalVariables) {
            this.globalVariables = globalVariables;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ProcessSettings.ProcessSettingsBuilder(name=" + this.name + ", inputs=" + this.inputs + ", currentStatement=" + this.currentStatement + ", referToInput=" + this.referToInput + ", prerequisites=" + this.prerequisites + ", command=" + this.command + ", validations=" + this.validations + ", globalVariables=" + this.globalVariables + ")";
        }
    }

    private static final class ProcessSettingsBuilderImpl
    extends ProcessSettingsBuilder<ProcessSettings, ProcessSettingsBuilderImpl> {
        private ProcessSettingsBuilderImpl() {
        }

        @Override
        protected ProcessSettingsBuilderImpl self() {
            return this;
        }

        @Override
        public ProcessSettings build() {
            return new ProcessSettings(this);
        }
    }
}

