/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.executable;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.qubership.atp.mia.exceptions.rest.RestIncorrectEndpointException;
import org.qubership.atp.mia.exceptions.rest.UnsupportedRestMethodException;
import org.qubership.atp.mia.model.impl.executable.RestLoopParameters;
import org.qubership.atp.mia.model.rest.methods.HttpConnect;
import org.qubership.atp.mia.model.rest.methods.HttpMkcol;
import org.qubership.atp.mia.model.rest.methods.HttpPropfind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rest
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Rest.class);
    private static final long serialVersionUID = -3948743951276707091L;
    private String restFile;
    private String endpoint;
    private String method;
    private String headers;
    private String body;
    private String bodyFile;
    private boolean parseResponseAsTable;
    private boolean hasFile;
    private boolean disableRedirect;
    private boolean saveCookie;
    private RestLoopParameters restLoopParameters;
    private boolean checkStatusCodeFlag;
    @Nullable
    private List<String> checkStatusCode;
    private String script;

    public Rest clone() {
        RestBuilder builder = this.toBuilder();
        if (this.checkStatusCode != null) {
            builder.checkStatusCode(new ArrayList<String>(this.checkStatusCode));
        }
        return builder.build();
    }

    public static RestBuilder builder() {
        return new RestBuilder();
    }

    public RestBuilder toBuilder() {
        return new RestBuilder().restFile(this.restFile).endpoint(this.endpoint).method(this.method).headers(this.headers).body(this.body).bodyFile(this.bodyFile).parseResponseAsTable(this.parseResponseAsTable).hasFile(this.hasFile).disableRedirect(this.disableRedirect).saveCookie(this.saveCookie).restLoopParameters(this.restLoopParameters).checkStatusCodeFlag(this.checkStatusCodeFlag).checkStatusCode(this.checkStatusCode).script(this.script);
    }

    public String getRestFile() {
        return this.restFile;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public String getBodyFile() {
        return this.bodyFile;
    }

    public boolean isParseResponseAsTable() {
        return this.parseResponseAsTable;
    }

    public boolean isHasFile() {
        return this.hasFile;
    }

    public boolean isDisableRedirect() {
        return this.disableRedirect;
    }

    public boolean isSaveCookie() {
        return this.saveCookie;
    }

    public RestLoopParameters getRestLoopParameters() {
        return this.restLoopParameters;
    }

    public boolean isCheckStatusCodeFlag() {
        return this.checkStatusCodeFlag;
    }

    @Nullable
    public List<String> getCheckStatusCode() {
        return this.checkStatusCode;
    }

    public String getScript() {
        return this.script;
    }

    public void setRestFile(String restFile) {
        this.restFile = restFile;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setBodyFile(String bodyFile) {
        this.bodyFile = bodyFile;
    }

    public void setParseResponseAsTable(boolean parseResponseAsTable) {
        this.parseResponseAsTable = parseResponseAsTable;
    }

    public void setHasFile(boolean hasFile) {
        this.hasFile = hasFile;
    }

    public void setDisableRedirect(boolean disableRedirect) {
        this.disableRedirect = disableRedirect;
    }

    public void setSaveCookie(boolean saveCookie) {
        this.saveCookie = saveCookie;
    }

    public void setRestLoopParameters(RestLoopParameters restLoopParameters) {
        this.restLoopParameters = restLoopParameters;
    }

    public void setCheckStatusCodeFlag(boolean checkStatusCodeFlag) {
        this.checkStatusCodeFlag = checkStatusCodeFlag;
    }

    public void setCheckStatusCode(@Nullable List<String> checkStatusCode) {
        this.checkStatusCode = checkStatusCode;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rest)) {
            return false;
        }
        Rest other = (Rest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isParseResponseAsTable() != other.isParseResponseAsTable()) {
            return false;
        }
        if (this.isHasFile() != other.isHasFile()) {
            return false;
        }
        if (this.isDisableRedirect() != other.isDisableRedirect()) {
            return false;
        }
        if (this.isSaveCookie() != other.isSaveCookie()) {
            return false;
        }
        if (this.isCheckStatusCodeFlag() != other.isCheckStatusCodeFlag()) {
            return false;
        }
        String this$restFile = this.getRestFile();
        String other$restFile = other.getRestFile();
        if (this$restFile == null ? other$restFile != null : !this$restFile.equals(other$restFile)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$headers = this.getHeaders();
        String other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$bodyFile = this.getBodyFile();
        String other$bodyFile = other.getBodyFile();
        if (this$bodyFile == null ? other$bodyFile != null : !this$bodyFile.equals(other$bodyFile)) {
            return false;
        }
        RestLoopParameters this$restLoopParameters = this.getRestLoopParameters();
        RestLoopParameters other$restLoopParameters = other.getRestLoopParameters();
        if (this$restLoopParameters == null ? other$restLoopParameters != null : !((Object)this$restLoopParameters).equals(other$restLoopParameters)) {
            return false;
        }
        List<String> this$checkStatusCode = this.getCheckStatusCode();
        List<String> other$checkStatusCode = other.getCheckStatusCode();
        if (this$checkStatusCode == null ? other$checkStatusCode != null : !((Object)this$checkStatusCode).equals(other$checkStatusCode)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        return !(this$script == null ? other$script != null : !this$script.equals(other$script));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isParseResponseAsTable() ? 79 : 97);
        result = result * 59 + (this.isHasFile() ? 79 : 97);
        result = result * 59 + (this.isDisableRedirect() ? 79 : 97);
        result = result * 59 + (this.isSaveCookie() ? 79 : 97);
        result = result * 59 + (this.isCheckStatusCodeFlag() ? 79 : 97);
        String $restFile = this.getRestFile();
        result = result * 59 + ($restFile == null ? 43 : $restFile.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $bodyFile = this.getBodyFile();
        result = result * 59 + ($bodyFile == null ? 43 : $bodyFile.hashCode());
        RestLoopParameters $restLoopParameters = this.getRestLoopParameters();
        result = result * 59 + ($restLoopParameters == null ? 43 : ((Object)$restLoopParameters).hashCode());
        List<String> $checkStatusCode = this.getCheckStatusCode();
        result = result * 59 + ($checkStatusCode == null ? 43 : ((Object)$checkStatusCode).hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        return result;
    }

    public String toString() {
        return "Rest(restFile=" + this.getRestFile() + ", endpoint=" + this.getEndpoint() + ", method=" + this.getMethod() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", bodyFile=" + this.getBodyFile() + ", parseResponseAsTable=" + this.isParseResponseAsTable() + ", hasFile=" + this.isHasFile() + ", disableRedirect=" + this.isDisableRedirect() + ", saveCookie=" + this.isSaveCookie() + ", restLoopParameters=" + this.getRestLoopParameters() + ", checkStatusCodeFlag=" + this.isCheckStatusCodeFlag() + ", checkStatusCode=" + this.getCheckStatusCode() + ", script=" + this.getScript() + ")";
    }

    public Rest(String restFile, String endpoint, String method, String headers, String body, String bodyFile, boolean parseResponseAsTable, boolean hasFile, boolean disableRedirect, boolean saveCookie, RestLoopParameters restLoopParameters, boolean checkStatusCodeFlag, @Nullable List<String> checkStatusCode, String script) {
        this.restFile = restFile;
        this.endpoint = endpoint;
        this.method = method;
        this.headers = headers;
        this.body = body;
        this.bodyFile = bodyFile;
        this.parseResponseAsTable = parseResponseAsTable;
        this.hasFile = hasFile;
        this.disableRedirect = disableRedirect;
        this.saveCookie = saveCookie;
        this.restLoopParameters = restLoopParameters;
        this.checkStatusCodeFlag = checkStatusCodeFlag;
        this.checkStatusCode = checkStatusCode;
        this.script = script;
    }

    public Rest() {
    }

    public static class RestBuilder {
        private String restFile;
        private String endpoint;
        private String method;
        private String headers;
        private String body;
        private String bodyFile;
        private boolean parseResponseAsTable;
        private boolean hasFile;
        private boolean disableRedirect;
        private boolean saveCookie;
        private RestLoopParameters restLoopParameters;
        private boolean checkStatusCodeFlag;
        private List<String> checkStatusCode;
        private String script;

        RestBuilder() {
        }

        public RestBuilder restFile(String restFile) {
            this.restFile = restFile;
            return this;
        }

        public RestBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public RestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public RestBuilder headers(String headers) {
            this.headers = headers;
            return this;
        }

        public RestBuilder body(String body) {
            this.body = body;
            return this;
        }

        public RestBuilder bodyFile(String bodyFile) {
            this.bodyFile = bodyFile;
            return this;
        }

        public RestBuilder parseResponseAsTable(boolean parseResponseAsTable) {
            this.parseResponseAsTable = parseResponseAsTable;
            return this;
        }

        public RestBuilder hasFile(boolean hasFile) {
            this.hasFile = hasFile;
            return this;
        }

        public RestBuilder disableRedirect(boolean disableRedirect) {
            this.disableRedirect = disableRedirect;
            return this;
        }

        public RestBuilder saveCookie(boolean saveCookie) {
            this.saveCookie = saveCookie;
            return this;
        }

        public RestBuilder restLoopParameters(RestLoopParameters restLoopParameters) {
            this.restLoopParameters = restLoopParameters;
            return this;
        }

        public RestBuilder checkStatusCodeFlag(boolean checkStatusCodeFlag) {
            this.checkStatusCodeFlag = checkStatusCodeFlag;
            return this;
        }

        public RestBuilder checkStatusCode(@Nullable List<String> checkStatusCode) {
            this.checkStatusCode = checkStatusCode;
            return this;
        }

        public RestBuilder script(String script) {
            this.script = script;
            return this;
        }

        public Rest build() {
            return new Rest(this.restFile, this.endpoint, this.method, this.headers, this.body, this.bodyFile, this.parseResponseAsTable, this.hasFile, this.disableRedirect, this.saveCookie, this.restLoopParameters, this.checkStatusCodeFlag, this.checkStatusCode, this.script);
        }

        public String toString() {
            return "Rest.RestBuilder(restFile=" + this.restFile + ", endpoint=" + this.endpoint + ", method=" + this.method + ", headers=" + this.headers + ", body=" + this.body + ", bodyFile=" + this.bodyFile + ", parseResponseAsTable=" + this.parseResponseAsTable + ", hasFile=" + this.hasFile + ", disableRedirect=" + this.disableRedirect + ", saveCookie=" + this.saveCookie + ", restLoopParameters=" + this.restLoopParameters + ", checkStatusCodeFlag=" + this.checkStatusCodeFlag + ", checkStatusCode=" + this.checkStatusCode + ", script=" + this.script + ")";
        }
    }

    public static enum RestMethod {
        GET(HttpGet.class),
        POST(HttpPost.class),
        PUT(HttpPut.class),
        DELETE(HttpDelete.class),
        PATCH(HttpPatch.class),
        HEAD(HttpHead.class),
        CONNECT(HttpConnect.class),
        OPTION(HttpOptions.class),
        TRACE(HttpTrace.class),
        PROPFIND(HttpPropfind.class),
        MKCOL(HttpMkcol.class);

        private Class<HttpRequestBase> methodClass;

        private RestMethod(Class httpMethodClass) {
            this.methodClass = httpMethodClass;
        }

        public HttpRequestBase getHttpRequest(String url) {
            try {
                return this.methodClass.getConstructor(String.class).newInstance(url);
            }
            catch (InvocationTargetException ite) {
                if (ite.getTargetException() != null && ite.getTargetException().getCause() != null && (ite.getTargetException().getCause().toString().contains("java.net.URISyntaxException: Illegal character in path at index") || ite.getTargetException().getCause().toString().contains("Illegal character in query at index"))) {
                    throw new RestIncorrectEndpointException(ite.getTargetException().getMessage());
                }
                throw new UnsupportedRestMethodException(ite.getCause() != null ? ite.getCause() : ite);
            }
            catch (Exception e) {
                throw new UnsupportedRestMethodException(e);
            }
        }
    }
}

