/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.generation;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.qubership.atp.mia.exceptions.testdata.MatrixEthalonReadFailException;
import org.qubership.atp.mia.exceptions.testdata.MatrixEthalonWriteFailException;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.impl.VariableFormat;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template {
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    private final MiaContext miaContext;
    private final MiaFileService miaFileService;
    private final Path ethalonFilePath;
    private final String fileExtension;
    private final Charset charset;
    private final String sanitizedFileName;
    private final String outputFileName;
    private String content;
    private Path generatedFile;

    public Template(MiaContext miaContext, MiaFileService miaFileService, String relativeEthalonPath, String rawOutputFileName, String fileExtension, Charset charset) {
        log.info("Initializing Template with ethalonPath: {}, outputName: {}, extension: {}", new Object[]{relativeEthalonPath, rawOutputFileName, fileExtension});
        this.miaContext = miaContext;
        this.miaFileService = miaFileService;
        this.ethalonFilePath = miaContext.getProjectFilePath().resolve(Paths.get(relativeEthalonPath, new String[0])).normalize();
        log.debug("Resolved ethalonFilePath: {}", (Object)this.ethalonFilePath);
        this.sanitizedFileName = Template.sanitizeFileName(rawOutputFileName);
        log.debug("Sanitized fileName: {}", (Object)this.sanitizedFileName);
        this.outputFileName = this.sanitizedFileName + (fileExtension != null ? fileExtension : "");
        this.fileExtension = fileExtension;
        this.charset = charset != null ? charset : StandardCharsets.UTF_8;
        log.info("Template successfully initialized for: {}", (Object)this.outputFileName);
    }

    private static String sanitizeFileName(String input) {
        return Paths.get(input, new String[0]).getFileName().toString();
    }

    public void evaluateFile() {
        this.evaluateContent(this.miaContext.getFlowData().getParameters());
        this.writeContent();
    }

    private String readContent() {
        try {
            this.miaFileService.getFile(this.ethalonFilePath.toFile());
            this.content = new String(Files.readAllBytes(this.ethalonFilePath), this.charset);
            this.content = this.miaContext.evaluate(this.content);
            return this.content;
        }
        catch (IOException e) {
            throw new MatrixEthalonReadFailException(this.ethalonFilePath.toString(), e);
        }
    }

    public String getContent() {
        return this.content == null ? this.readContent() : this.content;
    }

    public String evaluateContent(Map<String, String> additionalParams) {
        this.getContent();
        additionalParams.put("CURRENT_TEMPLATE_FILE_NAME", this.sanitizedFileName);
        additionalParams.put("CURRENT_TEMPLATE_FILE_EXTENSION", this.fileExtension);
        additionalParams.put("CURRENT_TEMPLATE_FILE_FULL_NAME", this.outputFileName);
        this.content = this.miaContext.evaluate(this.content, additionalParams);
        return this.content;
    }

    public void replaceContent(String from, String to) {
        if (from != null && !from.isEmpty() && to != null) {
            if (this.content == null) {
                this.readContent();
            }
            this.content = this.content.replaceFirst(from, to);
        }
    }

    public void evaluateTemplate(Command command, CommonConfiguration commonConf, Map<String, String> params) {
        String paramInTemplate = command.getTestDataParams().getEventParameterInTemplate();
        String eventTemplate = this.miaContext.evaluate(command.getTestDataParams().getEventTemplate(), params);
        VariableFormat varFormat = new VariableFormat(commonConf.getVariableFormat());
        String neededParamInTemplate = varFormat.getVariableAccordingFormat(paramInTemplate);
        this.replaceContent(neededParamInTemplate, eventTemplate + "\n" + neededParamInTemplate);
    }

    public File getFile() {
        if (this.generatedFile == null) {
            this.evaluateFile();
        }
        return this.generatedFile.toFile();
    }

    public void writeContent() {
        try {
            this.generatedFile = this.miaContext.getLogPath().resolve(this.outputFileName);
            log.trace("Write content into {} file:\n{}", (Object)this.generatedFile, (Object)this.content);
            Files.write(this.generatedFile, this.content.getBytes(this.charset), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MatrixEthalonWriteFailException(this.generatedFile, e);
        }
    }

    public String getFileName() {
        return this.outputFileName;
    }
}

