/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.macros.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.mia.model.impl.macros.Macros;
import org.qubership.atp.mia.model.impl.macros.MacrosType;

public class CheckDigitMacros
extends Macros<String> {
    public CheckDigitMacros() {
        super(MacrosType.Check_Digit.name());
    }

    @Override
    @Nullable
    public String evaluate(@Nonnull String[] inputs) {
        String card = inputs[0];
        if (!card.matches("\\d+")) {
            return null;
        }
        int[] digits = new int[card.length()];
        for (int cardIdx = 0; cardIdx < card.length(); ++cardIdx) {
            digits[cardIdx] = Character.getNumericValue(card.charAt(cardIdx));
        }
        for (int digitIdx = digits.length - 1; digitIdx >= 0; digitIdx -= 2) {
            int n = digitIdx;
            digits[n] = digits[n] + digits[digitIdx];
            if (digits[digitIdx] < 10) continue;
            digits[digitIdx] = digits[digitIdx] - 9;
        }
        int sum = 0;
        for (int digitIdx = 0; digitIdx < digits.length; ++digitIdx) {
            sum += digits[digitIdx];
        }
        String digit = String.valueOf(sum *= 9);
        return digit.substring(digit.length() - 1);
    }
}

