/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.qubership.atp.mia.exceptions.fileservice.ReadFailFileNotFoundException;
import org.qubership.atp.mia.exceptions.fileservice.ReadFailIoExceptionDuringOperation;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.model.impl.output.MarkedContent;
import org.qubership.atp.mia.model.pot.Link;
import org.qubership.atp.mia.model.pot.Statuses;
import org.qubership.atp.mia.service.MiaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class CommandOutput {
    private static final Logger log = LoggerFactory.getLogger(CommandOutput.class);
    @Nonnull
    private final String internalPathToFile;
    private final String externalPathToFile;
    private Link link;
    private final boolean displayed;
    private LinkedList<String> content = new LinkedList();
    private LinkedList<MarkedContent> markedContent = new LinkedList();
    private boolean isSizeExceedLimit = false;

    private CommandOutput() {
        this.internalPathToFile = "";
        this.externalPathToFile = "";
        this.link = null;
        this.displayed = true;
    }

    public CommandOutput(String internalPathToFile, String externalPathToFile, boolean isDisplayed, MiaContext miaContext) {
        this(internalPathToFile, externalPathToFile, null, isDisplayed, miaContext);
    }

    public CommandOutput(String internalPathToFile, String externalPathToFile, List<String> errorMessage, boolean isDisplayed, MiaContext miaContext) {
        this.internalPathToFile = internalPathToFile;
        this.externalPathToFile = externalPathToFile;
        this.link = MiaContext.getLogLinkOnUi(internalPathToFile);
        if (errorMessage != null) {
            errorMessage.forEach(e -> this.addContent((String)e, Statuses.FAIL));
        }
        this.displayed = isDisplayed;
    }

    public LinkedList<String> contentFromFile() {
        String internalPathToFile = this.internalPathToFile;
        if (internalPathToFile.contains("..") || internalPathToFile.contains("//") || internalPathToFile.startsWith("/") || internalPathToFile.startsWith("\\")) {
            throw new SecurityException("Invalid path: Path traversal attempt detected -> " + internalPathToFile);
        }
        File file = new File(internalPathToFile).getAbsoluteFile();
        LinkedList<String> content = this.content;
        if (content == null || content.isEmpty()) {
            log.info("Read full content of file [{}]...", (Object)internalPathToFile);
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                content = new LinkedList();
                while ((line = br.readLine()) != null) {
                    content.add(line);
                }
                log.info("Read full content of file [{}] DONE", (Object)internalPathToFile);
            }
            catch (FileNotFoundException e) {
                throw new ReadFailFileNotFoundException(internalPathToFile);
            }
            catch (IOException e) {
                throw new ReadFailIoExceptionDuringOperation(internalPathToFile, e);
            }
        }
        return content;
    }

    public void saveLatestLineToContent(int amountOfLines, long limitSizeBytes) {
        int linesCount = Math.min(10, amountOfLines);
        log.info("Saving last line of the content. Getting last line of file [{}]...", (Object)this.internalPathToFile);
        File file = new File(this.internalPathToFile);
        if (file.exists()) {
            try (ReversedLinesFileReader lastLineReader = new ReversedLinesFileReader(file);){
                if (this.markedContent != null && !this.markedContent.isEmpty()) {
                    log.info("Rewriting Marked Content is not empty = [{}]", this.markedContent);
                }
                this.markedContent = new LinkedList();
                while (linesCount-- > 0) {
                    String lastLine = lastLineReader.readLine();
                    if (lastLine == null) {
                        log.warn("File is empty [{}], set last line as empty string", (Object)this.internalPathToFile);
                        lastLine = "";
                        this.addContent(lastLine, Statuses.UNKNOWN);
                        break;
                    }
                    this.addContent(lastLine, Statuses.UNKNOWN);
                }
                log.info("Get last line of file [{}] DONE", (Object)this.internalPathToFile);
            }
            catch (IOException e) {
                throw new ReadFailIoExceptionDuringOperation(file.toString(), e);
            }
            this.isSizeExceedLimit = file.length() > limitSizeBytes;
        } else {
            this.addContent(ErrorCodes.MIA_2053_READ_FAIL_FILE_NOT_FOUND.getMessage(file.toString()), Statuses.FAIL);
        }
    }

    public void addContent(@NonNull String contentLine, @NonNull Statuses state) {
        this.markedContent.add(new MarkedContent(contentLine, state));
    }

    public void addContent(@NonNull String contentLine) {
        this.markedContent.add(new MarkedContent(contentLine, Statuses.UNKNOWN));
    }

    public void concatContent(CommandOutput commandOutput) {
        if (commandOutput != null && commandOutput.getMarkedContent() != null) {
            if (this.markedContent == null) {
                this.markedContent = new LinkedList();
            }
            this.markedContent.addAll(commandOutput.getMarkedContent());
        }
    }

    public boolean containsMarkedContentWithState(Statuses state) {
        return this.markedContent.stream().anyMatch(mc -> mc.getState().equals((Object)state));
    }

    public LinkedList<String> getContent() {
        return new LinkedList<String>();
    }

    @Nonnull
    public String getInternalPathToFile() {
        return this.internalPathToFile;
    }

    public String getExternalPathToFile() {
        return this.externalPathToFile;
    }

    public Link getLink() {
        return this.link;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public LinkedList<MarkedContent> getMarkedContent() {
        return this.markedContent;
    }

    public boolean isSizeExceedLimit() {
        return this.isSizeExceedLimit;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public void setContent(LinkedList<String> content) {
        this.content = content;
    }

    public void setMarkedContent(LinkedList<MarkedContent> markedContent) {
        this.markedContent = markedContent;
    }

    public void setSizeExceedLimit(boolean isSizeExceedLimit) {
        this.isSizeExceedLimit = isSizeExceedLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandOutput)) {
            return false;
        }
        CommandOutput other = (CommandOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisplayed() != other.isDisplayed()) {
            return false;
        }
        if (this.isSizeExceedLimit() != other.isSizeExceedLimit()) {
            return false;
        }
        String this$internalPathToFile = this.getInternalPathToFile();
        String other$internalPathToFile = other.getInternalPathToFile();
        if (this$internalPathToFile == null ? other$internalPathToFile != null : !this$internalPathToFile.equals(other$internalPathToFile)) {
            return false;
        }
        String this$externalPathToFile = this.getExternalPathToFile();
        String other$externalPathToFile = other.getExternalPathToFile();
        if (this$externalPathToFile == null ? other$externalPathToFile != null : !this$externalPathToFile.equals(other$externalPathToFile)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        LinkedList<String> this$content = this.getContent();
        LinkedList<String> other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        LinkedList<MarkedContent> this$markedContent = this.getMarkedContent();
        LinkedList<MarkedContent> other$markedContent = other.getMarkedContent();
        return !(this$markedContent == null ? other$markedContent != null : !((Object)this$markedContent).equals(other$markedContent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandOutput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisplayed() ? 79 : 97);
        result = result * 59 + (this.isSizeExceedLimit() ? 79 : 97);
        String $internalPathToFile = this.getInternalPathToFile();
        result = result * 59 + ($internalPathToFile == null ? 43 : $internalPathToFile.hashCode());
        String $externalPathToFile = this.getExternalPathToFile();
        result = result * 59 + ($externalPathToFile == null ? 43 : $externalPathToFile.hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        LinkedList<String> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        LinkedList<MarkedContent> $markedContent = this.getMarkedContent();
        result = result * 59 + ($markedContent == null ? 43 : ((Object)$markedContent).hashCode());
        return result;
    }

    public String toString() {
        return "CommandOutput(internalPathToFile=" + this.getInternalPathToFile() + ", externalPathToFile=" + this.getExternalPathToFile() + ", link=" + this.getLink() + ", displayed=" + this.isDisplayed() + ", content=" + this.getContent() + ", markedContent=" + this.getMarkedContent() + ", isSizeExceedLimit=" + this.isSizeExceedLimit() + ")";
    }
}

